// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Analyze operation result.
 */
@Fluent
public final class AnalyzeResult implements JsonSerializable<AnalyzeResult> {
    /*
     * Version of schema used for this result.
     */
    private String version;

    /*
     * Text extracted from the input.
     */
    private List<ReadResult> readResults;

    /*
     * Page-level information extracted from the input.
     */
    private List<PageResult> pageResults;

    /*
     * Document-level information extracted from the input.
     */
    private List<DocumentResult> documentResults;

    /*
     * List of errors reported during the analyze operation.
     */
    private List<ErrorInformation> errors;

    /**
     * Creates an instance of AnalyzeResult class.
     */
    public AnalyzeResult() {
    }

    /**
     * Get the version property: Version of schema used for this result.
     * 
     * @return the version value.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Set the version property: Version of schema used for this result.
     * 
     * @param version the version value to set.
     * @return the AnalyzeResult object itself.
     */
    public AnalyzeResult setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the readResults property: Text extracted from the input.
     * 
     * @return the readResults value.
     */
    public List<ReadResult> getReadResults() {
        return this.readResults;
    }

    /**
     * Set the readResults property: Text extracted from the input.
     * 
     * @param readResults the readResults value to set.
     * @return the AnalyzeResult object itself.
     */
    public AnalyzeResult setReadResults(List<ReadResult> readResults) {
        this.readResults = readResults;
        return this;
    }

    /**
     * Get the pageResults property: Page-level information extracted from the input.
     * 
     * @return the pageResults value.
     */
    public List<PageResult> getPageResults() {
        return this.pageResults;
    }

    /**
     * Set the pageResults property: Page-level information extracted from the input.
     * 
     * @param pageResults the pageResults value to set.
     * @return the AnalyzeResult object itself.
     */
    public AnalyzeResult setPageResults(List<PageResult> pageResults) {
        this.pageResults = pageResults;
        return this;
    }

    /**
     * Get the documentResults property: Document-level information extracted from the input.
     * 
     * @return the documentResults value.
     */
    public List<DocumentResult> getDocumentResults() {
        return this.documentResults;
    }

    /**
     * Set the documentResults property: Document-level information extracted from the input.
     * 
     * @param documentResults the documentResults value to set.
     * @return the AnalyzeResult object itself.
     */
    public AnalyzeResult setDocumentResults(List<DocumentResult> documentResults) {
        this.documentResults = documentResults;
        return this;
    }

    /**
     * Get the errors property: List of errors reported during the analyze operation.
     * 
     * @return the errors value.
     */
    public List<ErrorInformation> getErrors() {
        return this.errors;
    }

    /**
     * Set the errors property: List of errors reported during the analyze operation.
     * 
     * @param errors the errors value to set.
     * @return the AnalyzeResult object itself.
     */
    public AnalyzeResult setErrors(List<ErrorInformation> errors) {
        this.errors = errors;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeArrayField("readResults", this.readResults, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("pageResults", this.pageResults, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("documentResults", this.documentResults,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzeResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzeResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AnalyzeResult.
     */
    public static AnalyzeResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AnalyzeResult deserializedAnalyzeResult = new AnalyzeResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("version".equals(fieldName)) {
                    deserializedAnalyzeResult.version = reader.getString();
                } else if ("readResults".equals(fieldName)) {
                    List<ReadResult> readResults = reader.readArray(reader1 -> ReadResult.fromJson(reader1));
                    deserializedAnalyzeResult.readResults = readResults;
                } else if ("pageResults".equals(fieldName)) {
                    List<PageResult> pageResults = reader.readArray(reader1 -> PageResult.fromJson(reader1));
                    deserializedAnalyzeResult.pageResults = pageResults;
                } else if ("documentResults".equals(fieldName)) {
                    List<DocumentResult> documentResults
                        = reader.readArray(reader1 -> DocumentResult.fromJson(reader1));
                    deserializedAnalyzeResult.documentResults = documentResults;
                } else if ("errors".equals(fieldName)) {
                    List<ErrorInformation> errors = reader.readArray(reader1 -> ErrorInformation.fromJson(reader1));
                    deserializedAnalyzeResult.errors = errors;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAnalyzeResult;
        });
    }
}
