// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;

/**
 * The AnalyzersAnalyzeInvoiceHeaders model.
 */
@Fluent
public final class AnalyzersAnalyzeInvoiceHeaders {
    /*
     * The Operation-Location property.
     */
    private String operationLocation;

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of AnalyzersAnalyzeInvoiceHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public AnalyzersAnalyzeInvoiceHeaders(HttpHeaders rawHeaders) {
        this.operationLocation = rawHeaders.getValue(HttpHeaderName.OPERATION_LOCATION);
    }

    /**
     * Get the operationLocation property: The Operation-Location property.
     * 
     * @return the operationLocation value.
     */
    public String getOperationLocation() {
        return this.operationLocation;
    }

    /**
     * Set the operationLocation property: The Operation-Location property.
     * 
     * @param operationLocation the operationLocation value to set.
     * @return the AnalyzersAnalyzeInvoiceHeaders object itself.
     */
    public AnalyzersAnalyzeInvoiceHeaders setOperationLocation(String operationLocation) {
        this.operationLocation = operationLocation;
        return this;
    }
}
