// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An object representing the appearance of the text line.
 */
@Fluent
public final class Appearance implements JsonSerializable<Appearance> {
    /*
     * An object representing the style of the text line.
     */
    private Style style;

    /**
     * Creates an instance of Appearance class.
     */
    public Appearance() {
    }

    /**
     * Get the style property: An object representing the style of the text line.
     * 
     * @return the style value.
     */
    public Style getStyle() {
        return this.style;
    }

    /**
     * Set the style property: An object representing the style of the text line.
     * 
     * @param style the style value to set.
     * @return the Appearance object itself.
     */
    public Appearance setStyle(Style style) {
        this.style = style;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("style", this.style);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Appearance from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Appearance if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Appearance.
     */
    public static Appearance fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Appearance deserializedAppearance = new Appearance();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("style".equals(fieldName)) {
                    deserializedAppearance.style = Style.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppearance;
        });
    }
}
