// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Status and result of the queued copy operation.
 */
@Fluent
public final class CopyOperationResult implements JsonSerializable<CopyOperationResult> {
    /*
     * Operation status.
     */
    private OperationStatus status;

    /*
     * Date and time (UTC) when the copy operation was submitted.
     */
    private OffsetDateTime createdDateTime;

    /*
     * Date and time (UTC) when the status was last updated.
     */
    private OffsetDateTime lastUpdatedDateTime;

    /*
     * Results of the copy operation.
     */
    private CopyResult copyResult;

    /**
     * Creates an instance of CopyOperationResult class.
     */
    public CopyOperationResult() {
    }

    /**
     * Get the status property: Operation status.
     * 
     * @return the status value.
     */
    public OperationStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Operation status.
     * 
     * @param status the status value to set.
     * @return the CopyOperationResult object itself.
     */
    public CopyOperationResult setStatus(OperationStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the createdDateTime property: Date and time (UTC) when the copy operation was submitted.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Date and time (UTC) when the copy operation was submitted.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the CopyOperationResult object itself.
     */
    public CopyOperationResult setCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the lastUpdatedDateTime property: Date and time (UTC) when the status was last updated.
     * 
     * @return the lastUpdatedDateTime value.
     */
    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    /**
     * Set the lastUpdatedDateTime property: Date and time (UTC) when the status was last updated.
     * 
     * @param lastUpdatedDateTime the lastUpdatedDateTime value to set.
     * @return the CopyOperationResult object itself.
     */
    public CopyOperationResult setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    /**
     * Get the copyResult property: Results of the copy operation.
     * 
     * @return the copyResult value.
     */
    public CopyResult getCopyResult() {
        return this.copyResult;
    }

    /**
     * Set the copyResult property: Results of the copy operation.
     * 
     * @param copyResult the copyResult value to set.
     * @return the CopyOperationResult object itself.
     */
    public CopyOperationResult setCopyResult(CopyResult copyResult) {
        this.copyResult = copyResult;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime",
            this.lastUpdatedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeJsonField("copyResult", this.copyResult);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CopyOperationResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CopyOperationResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CopyOperationResult.
     */
    public static CopyOperationResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CopyOperationResult deserializedCopyOperationResult = new CopyOperationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedCopyOperationResult.status = OperationStatus.fromString(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedCopyOperationResult.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedCopyOperationResult.lastUpdatedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("copyResult".equals(fieldName)) {
                    deserializedCopyOperationResult.copyResult = CopyResult.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCopyOperationResult;
        });
    }
}
