// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about the extracted key-value pair.
 */
@Fluent
public final class KeyValuePair implements JsonSerializable<KeyValuePair> {
    /*
     * A user defined label for the key/value pair entry.
     */
    private String label;

    /*
     * Information about the extracted key in a key-value pair.
     */
    private KeyValueElement key;

    /*
     * Information about the extracted value in a key-value pair.
     */
    private KeyValueElement value;

    /*
     * Confidence value.
     */
    private float confidence;

    /**
     * Creates an instance of KeyValuePair class.
     */
    public KeyValuePair() {
    }

    /**
     * Get the label property: A user defined label for the key/value pair entry.
     * 
     * @return the label value.
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Set the label property: A user defined label for the key/value pair entry.
     * 
     * @param label the label value to set.
     * @return the KeyValuePair object itself.
     */
    public KeyValuePair setLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the key property: Information about the extracted key in a key-value pair.
     * 
     * @return the key value.
     */
    public KeyValueElement getKey() {
        return this.key;
    }

    /**
     * Set the key property: Information about the extracted key in a key-value pair.
     * 
     * @param key the key value to set.
     * @return the KeyValuePair object itself.
     */
    public KeyValuePair setKey(KeyValueElement key) {
        this.key = key;
        return this;
    }

    /**
     * Get the value property: Information about the extracted value in a key-value pair.
     * 
     * @return the value value.
     */
    public KeyValueElement getValue() {
        return this.value;
    }

    /**
     * Set the value property: Information about the extracted value in a key-value pair.
     * 
     * @param value the value value to set.
     * @return the KeyValuePair object itself.
     */
    public KeyValuePair setValue(KeyValueElement value) {
        this.value = value;
        return this;
    }

    /**
     * Get the confidence property: Confidence value.
     * 
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: Confidence value.
     * 
     * @param confidence the confidence value to set.
     * @return the KeyValuePair object itself.
     */
    public KeyValuePair setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", this.key);
        jsonWriter.writeJsonField("value", this.value);
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeStringField("label", this.label);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyValuePair from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyValuePair if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyValuePair.
     */
    public static KeyValuePair fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyValuePair deserializedKeyValuePair = new KeyValuePair();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    deserializedKeyValuePair.key = KeyValueElement.fromJson(reader);
                } else if ("value".equals(fieldName)) {
                    deserializedKeyValuePair.value = KeyValueElement.fromJson(reader);
                } else if ("confidence".equals(fieldName)) {
                    deserializedKeyValuePair.confidence = reader.getFloat();
                } else if ("label".equals(fieldName)) {
                    deserializedKeyValuePair.label = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyValuePair;
        });
    }
}
