// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Semantic data type of the key value element.
 */
public final class KeyValueType extends ExpandableStringEnum<KeyValueType> {
    /**
     * Static value string for KeyValueType.
     */
    public static final KeyValueType STRING = fromString("string");

    /**
     * Static value selectionMark for KeyValueType.
     */
    public static final KeyValueType SELECTION_MARK = fromString("selectionMark");

    /**
     * Creates a new instance of KeyValueType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public KeyValueType() {
    }

    /**
     * Creates or finds a KeyValueType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding KeyValueType.
     */
    public static KeyValueType fromString(String name) {
        return fromString(name, KeyValueType.class);
    }

    /**
     * Gets known KeyValueType values.
     * 
     * @return known KeyValueType values.
     */
    public static Collection<KeyValueType> values() {
        return values(KeyValueType.class);
    }
}
