// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Summary of all trained custom models.
 */
@Fluent
public final class ModelsSummary implements JsonSerializable<ModelsSummary> {
    /*
     * Current count of trained custom models.
     */
    private int count;

    /*
     * Max number of models that can be trained for this account.
     */
    private int limit;

    /*
     * Date and time (UTC) when the summary was last updated.
     */
    private OffsetDateTime lastUpdatedDateTime;

    /**
     * Creates an instance of ModelsSummary class.
     */
    public ModelsSummary() {
    }

    /**
     * Get the count property: Current count of trained custom models.
     * 
     * @return the count value.
     */
    public int getCount() {
        return this.count;
    }

    /**
     * Set the count property: Current count of trained custom models.
     * 
     * @param count the count value to set.
     * @return the ModelsSummary object itself.
     */
    public ModelsSummary setCount(int count) {
        this.count = count;
        return this;
    }

    /**
     * Get the limit property: Max number of models that can be trained for this account.
     * 
     * @return the limit value.
     */
    public int getLimit() {
        return this.limit;
    }

    /**
     * Set the limit property: Max number of models that can be trained for this account.
     * 
     * @param limit the limit value to set.
     * @return the ModelsSummary object itself.
     */
    public ModelsSummary setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    /**
     * Get the lastUpdatedDateTime property: Date and time (UTC) when the summary was last updated.
     * 
     * @return the lastUpdatedDateTime value.
     */
    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    /**
     * Set the lastUpdatedDateTime property: Date and time (UTC) when the summary was last updated.
     * 
     * @param lastUpdatedDateTime the lastUpdatedDateTime value to set.
     * @return the ModelsSummary object itself.
     */
    public ModelsSummary setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("count", this.count);
        jsonWriter.writeIntField("limit", this.limit);
        jsonWriter.writeStringField("lastUpdatedDateTime",
            this.lastUpdatedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ModelsSummary from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ModelsSummary if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ModelsSummary.
     */
    public static ModelsSummary fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ModelsSummary deserializedModelsSummary = new ModelsSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("count".equals(fieldName)) {
                    deserializedModelsSummary.count = reader.getInt();
                } else if ("limit".equals(fieldName)) {
                    deserializedModelsSummary.limit = reader.getInt();
                } else if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedModelsSummary.lastUpdatedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedModelsSummary;
        });
    }
}
