// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Uri or local path to source data.
 */
@Fluent
public final class SourcePath implements JsonSerializable<SourcePath> {
    /*
     * File source path.
     */
    private String source;

    /**
     * Creates an instance of SourcePath class.
     */
    public SourcePath() {
    }

    /**
     * Get the source property: File source path.
     * 
     * @return the source value.
     */
    public String getSource() {
        return this.source;
    }

    /**
     * Set the source property: File source path.
     * 
     * @param source the source value to set.
     * @return the SourcePath object itself.
     */
    public SourcePath setSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourcePath from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourcePath if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the SourcePath.
     */
    public static SourcePath fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourcePath deserializedSourcePath = new SourcePath();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("source".equals(fieldName)) {
                    deserializedSourcePath.source = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourcePath;
        });
    }
}
