// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Request parameter to train a new custom model.
 */
@Fluent
public final class TrainRequest implements JsonSerializable<TrainRequest> {
    /*
     * Source path containing the training documents.
     */
    private String source;

    /*
     * Filter to apply to the documents in the source path for training.
     */
    private TrainSourceFilter sourceFilter;

    /*
     * Use label file for training a model.
     */
    private Boolean useLabelFile;

    /*
     * Optional user defined model name (max length: 1024).
     */
    private String modelName;

    /**
     * Creates an instance of TrainRequest class.
     */
    public TrainRequest() {
    }

    /**
     * Get the source property: Source path containing the training documents.
     * 
     * @return the source value.
     */
    public String getSource() {
        return this.source;
    }

    /**
     * Set the source property: Source path containing the training documents.
     * 
     * @param source the source value to set.
     * @return the TrainRequest object itself.
     */
    public TrainRequest setSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the sourceFilter property: Filter to apply to the documents in the source path for training.
     * 
     * @return the sourceFilter value.
     */
    public TrainSourceFilter getSourceFilter() {
        return this.sourceFilter;
    }

    /**
     * Set the sourceFilter property: Filter to apply to the documents in the source path for training.
     * 
     * @param sourceFilter the sourceFilter value to set.
     * @return the TrainRequest object itself.
     */
    public TrainRequest setSourceFilter(TrainSourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
        return this;
    }

    /**
     * Get the useLabelFile property: Use label file for training a model.
     * 
     * @return the useLabelFile value.
     */
    public Boolean isUseLabelFile() {
        return this.useLabelFile;
    }

    /**
     * Set the useLabelFile property: Use label file for training a model.
     * 
     * @param useLabelFile the useLabelFile value to set.
     * @return the TrainRequest object itself.
     */
    public TrainRequest setUseLabelFile(Boolean useLabelFile) {
        this.useLabelFile = useLabelFile;
        return this;
    }

    /**
     * Get the modelName property: Optional user defined model name (max length: 1024).
     * 
     * @return the modelName value.
     */
    public String getModelName() {
        return this.modelName;
    }

    /**
     * Set the modelName property: Optional user defined model name (max length: 1024).
     * 
     * @param modelName the modelName value to set.
     * @return the TrainRequest object itself.
     */
    public TrainRequest setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeJsonField("sourceFilter", this.sourceFilter);
        jsonWriter.writeBooleanField("useLabelFile", this.useLabelFile);
        jsonWriter.writeStringField("modelName", this.modelName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TrainRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TrainRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TrainRequest.
     */
    public static TrainRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrainRequest deserializedTrainRequest = new TrainRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("source".equals(fieldName)) {
                    deserializedTrainRequest.source = reader.getString();
                } else if ("sourceFilter".equals(fieldName)) {
                    deserializedTrainRequest.sourceFilter = TrainSourceFilter.fromJson(reader);
                } else if ("useLabelFile".equals(fieldName)) {
                    deserializedTrainRequest.useLabelFile = reader.getNullable(JsonReader::getBoolean);
                } else if ("modelName".equals(fieldName)) {
                    deserializedTrainRequest.modelName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTrainRequest;
        });
    }
}
