// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.training.models;

/**
 * Defines values for CustomFormModelStatus.
 */
public enum CustomFormModelStatus {
    /**
     * Enum value creating.
     */
    CREATING("creating"),

    /**
     * Enum value ready.
     */
    READY("ready"),

    /**
     * Enum value invalid.
     */
    INVALID("invalid");

    /**
     * The actual serialized value for a CustomFormModelStatus instance.
     */
    private final String value;

    CustomFormModelStatus(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CustomFormModelStatus instance.
     *
     * @param value the serialized value to parse.
     *
     * @return the parsed CustomFormModelStatus object, or null if unable to parse.
     */
    public static CustomFormModelStatus fromString(String value) {
        CustomFormModelStatus[] items = CustomFormModelStatus.values();
        for (CustomFormModelStatus item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * The string representation of the enum value.
     *
     * @return the string representation of the enum value.
     */
    public String toString() {
        return this.value;
    }
}
