/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.FormRecognizerClientBuilder;
import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.Transforms;
import com.azure.ai.formrecognizer.implementation.AnalyzersImpl;
import com.azure.ai.formrecognizer.implementation.CustomModelsImpl;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeBusinessCardHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeIdDocumentHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeInvoiceHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeLayoutHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeReceiptHeaders;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsAnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.implementation.models.Language;
import com.azure.ai.formrecognizer.implementation.models.Locale;
import com.azure.ai.formrecognizer.implementation.models.ReadingOrder;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.ai.formrecognizer.models.FormContentType;
import com.azure.ai.formrecognizer.models.FormPage;
import com.azure.ai.formrecognizer.models.FormRecognizerErrorInformation;
import com.azure.ai.formrecognizer.models.FormRecognizerException;
import com.azure.ai.formrecognizer.models.FormRecognizerLocale;
import com.azure.ai.formrecognizer.models.FormRecognizerOperationResult;
import com.azure.ai.formrecognizer.models.RecognizeBusinessCardsOptions;
import com.azure.ai.formrecognizer.models.RecognizeContentOptions;
import com.azure.ai.formrecognizer.models.RecognizeCustomFormsOptions;
import com.azure.ai.formrecognizer.models.RecognizeIdentityDocumentOptions;
import com.azure.ai.formrecognizer.models.RecognizeInvoicesOptions;
import com.azure.ai.formrecognizer.models.RecognizeReceiptsOptions;
import com.azure.ai.formrecognizer.models.RecognizedForm;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=FormRecognizerClientBuilder.class, isAsync=true)
public final class FormRecognizerAsyncClient {
    private final ClientLogger logger = new ClientLogger(FormRecognizerAsyncClient.class);
    private final FormRecognizerClientImpl service;
    private final AnalyzersImpl analyzersImpl;
    private final CustomModelsImpl customModelsImpl;
    private final FormRecognizerServiceVersion serviceVersion;

    FormRecognizerAsyncClient(FormRecognizerClientImpl service, FormRecognizerServiceVersion serviceVersion) {
        this.service = service;
        this.analyzersImpl = service.getAnalyzers();
        this.customModelsImpl = service.getCustomModels();
        this.serviceVersion = serviceVersion;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String modelId, String formUrl) {
        return this.beginRecognizeCustomFormsFromUrl(modelId, formUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String modelId, String formUrl, RecognizeCustomFormsOptions recognizeCustomFormsOptions) {
        return this.beginRecognizeCustomFormsFromUrl(formUrl, modelId, recognizeCustomFormsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String formUrl, String modelId, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        try {
            if (formUrl == null) {
                return PollerFlux.error((Exception)new NullPointerException("'formUrl' is required and cannot be null."));
            }
            if (modelId == null) {
                return PollerFlux.error((Exception)new NullPointerException("'modelId' is required and cannot be null or empty"));
            }
            RecognizeCustomFormsOptions finalRecognizeCustomFormsOptions = Utility.getRecognizeCustomFormOptions(recognizeCustomFormsOptions);
            UUID modelUuid = UUID.fromString(modelId);
            boolean isFieldElementsIncluded = finalRecognizeCustomFormsOptions.isFieldElementsIncluded();
            return new PollerFlux(finalRecognizeCustomFormsOptions.getPollInterval(), Utility.urlActivationOperation(() -> this.customModelsImpl.analyzeDocumentWithResponseAsync(modelUuid, isFieldElementsIncluded, finalRecognizeCustomFormsOptions.getPages(), new SourcePath().setSource(formUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((CustomModelsAnalyzeDocumentHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultUid -> this.customModelsImpl.getAnalyzeResultWithResponseAsync(modelUuid, (UUID)resultUid, context)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.customModelsImpl.getAnalyzeResultWithResponseAsync(modelUuid, (UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, modelId)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, Flux<ByteBuffer> form, long length) {
        return this.beginRecognizeCustomForms(modelId, form, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, Flux<ByteBuffer> form, long length, RecognizeCustomFormsOptions recognizeCustomFormsOptions) {
        return this.beginRecognizeCustomForms(modelId, form, length, recognizeCustomFormsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, Flux<ByteBuffer> form, long length, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        try {
            if (form == null) {
                return PollerFlux.error((Exception)new NullPointerException("'form' is required and cannot be null."));
            }
            if (modelId == null) {
                return PollerFlux.error((Exception)new NullPointerException("'modelId' is required and cannot be null or empty"));
            }
            RecognizeCustomFormsOptions finalRecognizeCustomFormsOptions = Utility.getRecognizeCustomFormOptions(recognizeCustomFormsOptions);
            UUID modelUuid = UUID.fromString(modelId);
            boolean isFieldElementsIncluded = finalRecognizeCustomFormsOptions.isFieldElementsIncluded();
            return new PollerFlux(finalRecognizeCustomFormsOptions.getPollInterval(), this.streamActivationOperation(contentType -> this.customModelsImpl.analyzeDocumentWithResponseAsync(modelUuid, ContentType.fromString(contentType.toString()), (Boolean)isFieldElementsIncluded, finalRecognizeCustomFormsOptions.getPages(), form, (Long)length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((CustomModelsAnalyzeDocumentHeaders)response.getDeserializedHeaders()).getOperationLocation()))), form, finalRecognizeCustomFormsOptions.getContentType()), this.pollingOperation(resultUuid -> this.customModelsImpl.getAnalyzeResultWithResponseAsync(modelUuid, (UUID)resultUuid, context)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.customModelsImpl.getAnalyzeResultWithResponseAsync(modelUuid, (UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, modelId)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl) {
        return this.beginRecognizeContentFromUrl(formUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl, RecognizeContentOptions recognizeContentOptions) {
        return this.beginRecognizeContentFromUrl(formUrl, recognizeContentOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl, RecognizeContentOptions recognizeContentOptions, Context context) {
        try {
            if (formUrl == null) {
                return PollerFlux.error((Exception)new NullPointerException("'formUrl' is required and cannot be null."));
            }
            RecognizeContentOptions finalRecognizeContentOptions = Utility.getRecognizeContentOptions(recognizeContentOptions);
            return new PollerFlux(finalRecognizeContentOptions.getPollInterval(), Utility.urlActivationOperation(() -> this.analyzersImpl.analyzeLayoutWithResponseAsync(finalRecognizeContentOptions.getPages(), Language.fromString(Objects.toString((Object)finalRecognizeContentOptions.getLanguage(), null)), ReadingOrder.fromString(Objects.toString((Object)finalRecognizeContentOptions.getReadingOrder(), null)), new SourcePath().setSource(formUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeLayoutHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeLayoutResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeLayoutResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedLayout(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), true)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(Flux<ByteBuffer> form, long length) {
        return this.beginRecognizeContent(form, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(Flux<ByteBuffer> form, long length, RecognizeContentOptions recognizeContentOptions) {
        return this.beginRecognizeContent(form, length, recognizeContentOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(Flux<ByteBuffer> form, long length, RecognizeContentOptions recognizeContentOptions, Context context) {
        try {
            if (form == null) {
                return PollerFlux.error((Exception)new NullPointerException("'form' is required and cannot be null."));
            }
            RecognizeContentOptions finalRecognizeContentOptions = Utility.getRecognizeContentOptions(recognizeContentOptions);
            return new PollerFlux(finalRecognizeContentOptions.getPollInterval(), this.streamActivationOperation(contentType -> this.analyzersImpl.analyzeLayoutWithResponseAsync((ContentType)((Object)contentType), finalRecognizeContentOptions.getPages(), Language.fromString(Objects.toString((Object)finalRecognizeContentOptions.getLanguage(), null)), ReadingOrder.fromString(Objects.toString((Object)finalRecognizeContentOptions.getReadingOrder(), null)), form, (Long)length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeLayoutHeaders)response.getDeserializedHeaders()).getOperationLocation()))), form, finalRecognizeContentOptions.getContentType()), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeLayoutResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeLayoutResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedLayout(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), true)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl) {
        return this.beginRecognizeReceiptsFromUrl(receiptUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl, RecognizeReceiptsOptions recognizeReceiptsOptions) {
        return this.beginRecognizeReceiptsFromUrl(receiptUrl, recognizeReceiptsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        try {
            if (receiptUrl == null) {
                return PollerFlux.error((Exception)new NullPointerException("'receiptUrl' is required and cannot be null."));
            }
            RecognizeReceiptsOptions finalRecognizeReceiptsOptions = Utility.getRecognizeReceiptOptions(recognizeReceiptsOptions);
            boolean isFieldElementsIncluded = finalRecognizeReceiptsOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeReceiptsOptions.getLocale();
            return new PollerFlux(finalRecognizeReceiptsOptions.getPollInterval(), Utility.urlActivationOperation(() -> this.analyzersImpl.analyzeReceiptWithResponseAsync(isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeReceiptsOptions.getPages(), new SourcePath().setSource(receiptUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeReceiptHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeReceiptResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeReceiptResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(Flux<ByteBuffer> receipt, long length) {
        return this.beginRecognizeReceipts(receipt, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(Flux<ByteBuffer> receipt, long length, RecognizeReceiptsOptions recognizeReceiptsOptions) {
        return this.beginRecognizeReceipts(receipt, length, recognizeReceiptsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(Flux<ByteBuffer> receipt, long length, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        try {
            if (receipt == null) {
                return PollerFlux.error((Exception)new NullPointerException("'receipt' is required and cannot be null."));
            }
            RecognizeReceiptsOptions finalRecognizeReceiptsOptions = Utility.getRecognizeReceiptOptions(recognizeReceiptsOptions);
            boolean isFieldElementsIncluded = finalRecognizeReceiptsOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeReceiptsOptions.getLocale();
            return new PollerFlux(finalRecognizeReceiptsOptions.getPollInterval(), this.streamActivationOperation(contentType -> this.analyzersImpl.analyzeReceiptWithResponseAsync((ContentType)((Object)contentType), (Boolean)isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeReceiptsOptions.getPages(), receipt, (Long)length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeReceiptHeaders)response.getDeserializedHeaders()).getOperationLocation()))), receipt, finalRecognizeReceiptsOptions.getContentType()), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeReceiptResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeReceiptResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl) {
        return this.beginRecognizeBusinessCardsFromUrl(businessCardUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions) {
        return this.beginRecognizeBusinessCardsFromUrl(businessCardUrl, recognizeBusinessCardsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        try {
            if (businessCardUrl == null) {
                return PollerFlux.error((Exception)new NullPointerException("'businessCardUrl' is required and cannot be null."));
            }
            RecognizeBusinessCardsOptions finalRecognizeBusinessCardsOptions = Utility.getRecognizeBusinessCardsOptions(recognizeBusinessCardsOptions);
            boolean isFieldElementsIncluded = finalRecognizeBusinessCardsOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeBusinessCardsOptions.getLocale();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, Utility.urlActivationOperation(() -> this.analyzersImpl.analyzeBusinessCardWithResponseAsync(isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeBusinessCardsOptions.getPages(), new SourcePath().setSource(businessCardUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeBusinessCardHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeBusinessCardResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeBusinessCardResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(Flux<ByteBuffer> businessCard, long length) {
        return this.beginRecognizeBusinessCards(businessCard, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(Flux<ByteBuffer> businessCard, long length, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions) {
        return this.beginRecognizeBusinessCards(businessCard, length, recognizeBusinessCardsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(Flux<ByteBuffer> businessCard, long length, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        try {
            if (businessCard == null) {
                return PollerFlux.error((Exception)new NullPointerException("'businessCard' is required and cannot be null."));
            }
            RecognizeBusinessCardsOptions finalRecognizeBusinessCardsOptions = Utility.getRecognizeBusinessCardsOptions(recognizeBusinessCardsOptions);
            boolean isFieldElementsIncluded = finalRecognizeBusinessCardsOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeBusinessCardsOptions.getLocale();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.streamActivationOperation(contentType -> this.analyzersImpl.analyzeBusinessCardWithResponseAsync((ContentType)((Object)contentType), (Boolean)isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeBusinessCardsOptions.getPages(), businessCard, (Long)length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeBusinessCardHeaders)response.getDeserializedHeaders()).getOperationLocation()))), businessCard, finalRecognizeBusinessCardsOptions.getContentType()), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeBusinessCardResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeBusinessCardResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl) {
        return this.beginRecognizeIdentityDocumentsFromUrl(identityDocumentUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions) {
        return this.beginRecognizeIdentityDocumentsFromUrl(identityDocumentUrl, recognizeIdentityDocumentOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        try {
            if (identityDocumentUrl == null) {
                return PollerFlux.error((Exception)new NullPointerException("'identityDocumentUrl' is required and cannot be null."));
            }
            RecognizeIdentityDocumentOptions finalRecognizeIdentityDocumentOptions = Utility.getRecognizeIdentityDocumentOptions(recognizeIdentityDocumentOptions);
            boolean isFieldElementsIncluded = finalRecognizeIdentityDocumentOptions.isFieldElementsIncluded();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, Utility.urlActivationOperation(() -> this.analyzersImpl.analyzeIdDocumentWithResponseAsync(isFieldElementsIncluded, finalRecognizeIdentityDocumentOptions.getPages(), new SourcePath().setSource(identityDocumentUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeIdDocumentHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeIdDocumentResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeIdDocumentResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(Flux<ByteBuffer> identityDocument, long length) {
        return this.beginRecognizeIdentityDocuments(identityDocument, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(Flux<ByteBuffer> identityDocument, long length, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions) {
        return this.beginRecognizeIdentityDocuments(identityDocument, length, recognizeIdentityDocumentOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(Flux<ByteBuffer> identityDocument, long length, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        try {
            if (identityDocument == null) {
                return PollerFlux.error((Exception)new NullPointerException("'identityDocument' is required and cannot be null."));
            }
            RecognizeIdentityDocumentOptions finalRecognizeIdentityDocumentOptions = Utility.getRecognizeIdentityDocumentOptions(recognizeIdentityDocumentOptions);
            boolean isFieldElementsIncluded = finalRecognizeIdentityDocumentOptions.isFieldElementsIncluded();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.streamActivationOperation(contentType -> this.analyzersImpl.analyzeIdDocumentWithResponseAsync((ContentType)((Object)contentType), (Boolean)isFieldElementsIncluded, finalRecognizeIdentityDocumentOptions.getPages(), identityDocument, (Long)length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeIdDocumentHeaders)response.getDeserializedHeaders()).getOperationLocation()))), identityDocument, finalRecognizeIdentityDocumentOptions.getContentType()), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeIdDocumentResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeIdDocumentResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<FormRecognizerOperationResult>> streamActivationOperation(Function<ContentType, Mono<FormRecognizerOperationResult>> activationOperation, Flux<ByteBuffer> form, FormContentType contentType) {
        return pollingContext -> {
            try {
                if (form == null) {
                    return Mono.error((Throwable)new NullPointerException("'form' is required and cannot be null."));
                }
                if (contentType != null) {
                    return ((Mono)activationOperation.apply(ContentType.fromString(contentType.toString()))).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
                }
                return Utility.detectContentType(form).flatMap(activationOperation).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<PollResponse<FormRecognizerOperationResult>>> pollingOperation(Function<UUID, Mono<Response<AnalyzeOperationResult>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID resultUuid = UUID.fromString(((FormRecognizerOperationResult)operationResultPollResponse.getValue()).getResultId());
                return ((Mono)pollingFunction.apply(resultUuid)).flatMap(modelResponse -> this.processAnalyzeModelResponse((Response<AnalyzeOperationResult>)modelResponse, (PollResponse<FormRecognizerOperationResult>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<Response<AnalyzeOperationResult>>> fetchingOperation(Function<UUID, Mono<Response<AnalyzeOperationResult>>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<FormRecognizerOperationResult>> processAnalyzeModelResponse(Response<AnalyzeOperationResult> analyzeOperationResultResponse, PollResponse<FormRecognizerOperationResult> operationResultPollResponse) {
        LongRunningOperationStatus status;
        switch (((AnalyzeOperationResult)analyzeOperationResultResponse.getValue()).getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)((Object)new FormRecognizerException("Analyze operation failed", ((AnalyzeOperationResult)analyzeOperationResultResponse.getValue()).getAnalyzeResult().getErrors().stream().map(errorInformation -> new FormRecognizerErrorInformation(errorInformation.getCode(), errorInformation.getMessage())).collect(Collectors.toList()))));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((AnalyzeOperationResult)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((FormRecognizerOperationResult)operationResultPollResponse.getValue())));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl) {
        return this.beginRecognizeInvoicesFromUrl(invoiceUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl, RecognizeInvoicesOptions recognizeInvoicesOptions) {
        return this.beginRecognizeInvoicesFromUrl(invoiceUrl, recognizeInvoicesOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        try {
            if (invoiceUrl == null) {
                return PollerFlux.error((Exception)new NullPointerException("'invoiceUrl' is required and cannot be null."));
            }
            RecognizeInvoicesOptions finalRecognizeInvoicesOptions = Utility.getRecognizeInvoicesOptions(recognizeInvoicesOptions);
            boolean isFieldElementsIncluded = finalRecognizeInvoicesOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeInvoicesOptions.getLocale();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, Utility.urlActivationOperation(() -> this.analyzersImpl.analyzeInvoiceWithResponseAsync(isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeInvoicesOptions.getPages(), new SourcePath().setSource(invoiceUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeInvoiceHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeInvoiceResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeInvoiceResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(Flux<ByteBuffer> invoice, long length) {
        return this.beginRecognizeInvoices(invoice, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(Flux<ByteBuffer> invoice, long length, RecognizeInvoicesOptions recognizeInvoicesOptions) {
        return this.beginRecognizeInvoices(invoice, length, recognizeInvoicesOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(Flux<ByteBuffer> invoice, long length, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        try {
            if (invoice == null) {
                return PollerFlux.error((Exception)new NullPointerException("'invoice' is required and cannot be null."));
            }
            RecognizeInvoicesOptions finalRecognizeInvoicesOptions = Utility.getRecognizeInvoicesOptions(recognizeInvoicesOptions);
            boolean isFieldElementsIncluded = finalRecognizeInvoicesOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeInvoicesOptions.getLocale();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.streamActivationOperation(contentType -> this.analyzersImpl.analyzeInvoiceWithResponseAsync((ContentType)((Object)contentType), (Boolean)isFieldElementsIncluded, Locale.fromString(Objects.toString((Object)localeInfo, null)), finalRecognizeInvoicesOptions.getPages(), invoice, (Long)length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzersAnalyzeInvoiceHeaders)response.getDeserializedHeaders()).getOperationLocation()))), invoice, finalRecognizeInvoicesOptions.getContentType()), this.pollingOperation(resultId -> this.analyzersImpl.getAnalyzeInvoiceResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.analyzersImpl.getAnalyzeInvoiceResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }
}

