/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation;

import com.azure.ai.formrecognizer.documentanalysis.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ContentType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelSummary;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsAnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsBuildModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsComposeModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsCopyModelToHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetDocumentModelsResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentAnalysisFeature;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.polling.SyncPollingStrategy;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DocumentModelsImpl {
    private final DocumentModelsService service;
    private final FormRecognizerClientImpl client;

    DocumentModelsImpl(FormRecognizerClientImpl client) {
        this.service = (DocumentModelsService)RestProxy.create(DocumentModelsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest) {
        return FluxUtil.withContext(context -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocument(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentSync(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest) {
        return FluxUtil.withContext(context -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeDocumentNoCustomHeadersWithResponse(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentNoCustomHeadersSync(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, AnalyzeDocumentRequest analyzeRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocument(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, Flux<ByteBuffer> analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocument(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentSync(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeDocumentNoCustomHeadersWithResponse(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentNoCustomHeadersSync(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, contentType, analyzeRequest, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, ContentType contentType, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, BinaryData analyzeRequest, Long contentLength, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, contentType, pages, locale, stringIndexType, features, analyzeRequest, contentLength, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return FluxUtil.withContext(context -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocument(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentSync(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return FluxUtil.withContext(context -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeDocumentNoCustomHeadersWithResponse(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest, Context context) {
        String accept = "application/json";
        String featuresConverted = features == null ? null : features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeDocumentNoCustomHeadersSync(this.client.getEndpoint(), modelId, pages, locale, stringIndexType, this.client.getApiVersion(), featuresConverted, analyzeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeadersAsync(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, pages, locale, stringIndexType, features, analyzeRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocumentNoCustomHeaders(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, String analyzeRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentNoCustomHeadersWithResponse(modelId, pages, locale, stringIndexType, features, analyzeRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeResultWithResponseAsync(String modelId, String resultId) {
        return FluxUtil.withContext(context -> this.getAnalyzeResultWithResponseAsync(modelId, resultId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeResultWithResponseAsync(String modelId, String resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeResult(this.client.getEndpoint(), modelId, resultId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeResultAsync(String modelId, String resultId) {
        return this.getAnalyzeResultWithResponseAsync(modelId, resultId).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeResultOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeResultAsync(String modelId, String resultId, Context context) {
        return this.getAnalyzeResultWithResponseAsync(modelId, resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeResultOperation)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeResultOperation> getAnalyzeResultWithResponse(String modelId, String resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeResultSync(this.client.getEndpoint(), modelId, resultId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeResultOperation getAnalyzeResult(String modelId, String resultId) {
        return (AnalyzeResultOperation)this.getAnalyzeResultWithResponse(modelId, resultId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsBuildModelHeaders, Void>> buildModelWithResponseAsync(BuildDocumentModelRequest buildRequest) {
        return FluxUtil.withContext(context -> this.buildModelWithResponseAsync(buildRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsBuildModelHeaders, Void>> buildModelWithResponseAsync(BuildDocumentModelRequest buildRequest, Context context) {
        String accept = "application/json";
        return this.service.buildModel(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentModelsBuildModelHeaders, Void> buildModelWithResponse(BuildDocumentModelRequest buildRequest, Context context) {
        String accept = "application/json";
        return this.service.buildModelSync(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildModelAsync(BuildDocumentModelRequest buildRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildModelWithResponseAsync(buildRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildModelAsync(BuildDocumentModelRequest buildRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildModelWithResponseAsync(buildRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModel(BuildDocumentModelRequest buildRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildModelWithResponse(buildRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModel(BuildDocumentModelRequest buildRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildModelWithResponse(buildRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> buildModelNoCustomHeadersWithResponseAsync(BuildDocumentModelRequest buildRequest) {
        return FluxUtil.withContext(context -> this.buildModelNoCustomHeadersWithResponseAsync(buildRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> buildModelNoCustomHeadersWithResponseAsync(BuildDocumentModelRequest buildRequest, Context context) {
        String accept = "application/json";
        return this.service.buildModelNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> buildModelNoCustomHeadersWithResponse(BuildDocumentModelRequest buildRequest, Context context) {
        String accept = "application/json";
        return this.service.buildModelNoCustomHeadersSync(this.client.getEndpoint(), this.client.getApiVersion(), buildRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildModelNoCustomHeadersAsync(BuildDocumentModelRequest buildRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildModelNoCustomHeadersWithResponseAsync(buildRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildModelNoCustomHeadersAsync(BuildDocumentModelRequest buildRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.buildModelNoCustomHeadersWithResponseAsync(buildRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModelNoCustomHeaders(BuildDocumentModelRequest buildRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildModelNoCustomHeadersWithResponse(buildRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildModelNoCustomHeaders(BuildDocumentModelRequest buildRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.buildModelNoCustomHeadersWithResponse(buildRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsComposeModelHeaders, Void>> composeModelWithResponseAsync(ComposeDocumentModelRequest composeRequest) {
        return FluxUtil.withContext(context -> this.composeModelWithResponseAsync(composeRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsComposeModelHeaders, Void>> composeModelWithResponseAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        String accept = "application/json";
        return this.service.composeModel(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentModelsComposeModelHeaders, Void> composeModelWithResponse(ComposeDocumentModelRequest composeRequest, Context context) {
        String accept = "application/json";
        return this.service.composeModelSync(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelAsync(ComposeDocumentModelRequest composeRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.composeModelWithResponseAsync(composeRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.composeModelWithResponseAsync(composeRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(ComposeDocumentModelRequest composeRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.composeModelWithResponse(composeRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(ComposeDocumentModelRequest composeRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.composeModelWithResponse(composeRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> composeModelNoCustomHeadersWithResponseAsync(ComposeDocumentModelRequest composeRequest) {
        return FluxUtil.withContext(context -> this.composeModelNoCustomHeadersWithResponseAsync(composeRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> composeModelNoCustomHeadersWithResponseAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        String accept = "application/json";
        return this.service.composeModelNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> composeModelNoCustomHeadersWithResponse(ComposeDocumentModelRequest composeRequest, Context context) {
        String accept = "application/json";
        return this.service.composeModelNoCustomHeadersSync(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelNoCustomHeadersAsync(ComposeDocumentModelRequest composeRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.composeModelNoCustomHeadersWithResponseAsync(composeRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelNoCustomHeadersAsync(ComposeDocumentModelRequest composeRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.composeModelNoCustomHeadersWithResponseAsync(composeRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModelNoCustomHeaders(ComposeDocumentModelRequest composeRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.composeModelNoCustomHeadersWithResponse(composeRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModelNoCustomHeaders(ComposeDocumentModelRequest composeRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.composeModelNoCustomHeadersWithResponse(composeRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeModelCopyWithResponseAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        return FluxUtil.withContext(context -> this.authorizeModelCopyWithResponseAsync(authorizeCopyRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeModelCopyWithResponseAsync(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        String accept = "application/json";
        return this.service.authorizeModelCopy(this.client.getEndpoint(), this.client.getApiVersion(), authorizeCopyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeModelCopyAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        return this.authorizeModelCopyWithResponseAsync(authorizeCopyRequest).flatMap(res -> Mono.justOrEmpty((Object)((CopyAuthorization)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeModelCopyAsync(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        return this.authorizeModelCopyWithResponseAsync(authorizeCopyRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((CopyAuthorization)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CopyAuthorization> authorizeModelCopyWithResponse(AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        String accept = "application/json";
        return this.service.authorizeModelCopySync(this.client.getEndpoint(), this.client.getApiVersion(), authorizeCopyRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CopyAuthorization authorizeModelCopy(AuthorizeCopyRequest authorizeCopyRequest) {
        return (CopyAuthorization)this.authorizeModelCopyWithResponse(authorizeCopyRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsCopyModelToHeaders, Void>> copyModelToWithResponseAsync(String modelId, CopyAuthorization copyToRequest) {
        return FluxUtil.withContext(context -> this.copyModelToWithResponseAsync(modelId, copyToRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DocumentModelsCopyModelToHeaders, Void>> copyModelToWithResponseAsync(String modelId, CopyAuthorization copyToRequest, Context context) {
        String accept = "application/json";
        return this.service.copyModelTo(this.client.getEndpoint(), modelId, this.client.getApiVersion(), copyToRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<DocumentModelsCopyModelToHeaders, Void> copyModelToWithResponse(String modelId, CopyAuthorization copyToRequest, Context context) {
        String accept = "application/json";
        return this.service.copyModelToSync(this.client.getEndpoint(), modelId, this.client.getApiVersion(), copyToRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToAsync(String modelId, CopyAuthorization copyToRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.copyModelToWithResponseAsync(modelId, copyToRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToAsync(String modelId, CopyAuthorization copyToRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.copyModelToWithResponseAsync(modelId, copyToRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, CopyAuthorization copyToRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.copyModelToWithResponse(modelId, copyToRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, CopyAuthorization copyToRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.copyModelToWithResponse(modelId, copyToRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> copyModelToNoCustomHeadersWithResponseAsync(String modelId, CopyAuthorization copyToRequest) {
        return FluxUtil.withContext(context -> this.copyModelToNoCustomHeadersWithResponseAsync(modelId, copyToRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> copyModelToNoCustomHeadersWithResponseAsync(String modelId, CopyAuthorization copyToRequest, Context context) {
        String accept = "application/json";
        return this.service.copyModelToNoCustomHeaders(this.client.getEndpoint(), modelId, this.client.getApiVersion(), copyToRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> copyModelToNoCustomHeadersWithResponse(String modelId, CopyAuthorization copyToRequest, Context context) {
        String accept = "application/json";
        return this.service.copyModelToNoCustomHeadersSync(this.client.getEndpoint(), modelId, this.client.getApiVersion(), copyToRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToNoCustomHeadersAsync(String modelId, CopyAuthorization copyToRequest) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.copyModelToNoCustomHeadersWithResponseAsync(modelId, copyToRequest), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToNoCustomHeadersAsync(String modelId, CopyAuthorization copyToRequest, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.copyModelToNoCustomHeadersWithResponseAsync(modelId, copyToRequest, context), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelToNoCustomHeaders(String modelId, CopyAuthorization copyToRequest) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.copyModelToNoCustomHeadersWithResponse(modelId, copyToRequest, Context.NONE), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(Context.NONE)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelToNoCustomHeaders(String modelId, CopyAuthorization copyToRequest, Context context) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.copyModelToNoCustomHeadersWithResponse(modelId, copyToRequest, context), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.client.getHttpPipeline()).setEndpoint("{endpoint}/formrecognizer".replace("{endpoint}", this.client.getEndpoint())).setContext(context)), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsSinglePageAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listModels(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsSinglePageAsync(Context context) {
        String accept = "application/json";
        return this.service.listModels(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> listModelsAsync() {
        return new PagedFlux(() -> this.listModelsSinglePageAsync(), nextLink -> this.listModelsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> listModelsAsync(Context context) {
        return new PagedFlux(() -> this.listModelsSinglePageAsync(context), nextLink -> this.listModelsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsSinglePage() {
        String accept = "application/json";
        Response<GetDocumentModelsResponse> res = this.service.listModelsSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsSinglePage(Context context) {
        String accept = "application/json";
        Response<GetDocumentModelsResponse> res = this.service.listModelsSync(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listModels() {
        return new PagedIterable(() -> this.listModelsSinglePage(Context.NONE), nextLink -> this.listModelsNextSinglePage((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> listModels(Context context) {
        return new PagedIterable(() -> this.listModelsSinglePage(context), nextLink -> this.listModelsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getModelWithResponseAsync(String modelId) {
        return FluxUtil.withContext(context -> this.getModelWithResponseAsync(modelId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getModelWithResponseAsync(String modelId, Context context) {
        String accept = "application/json";
        return this.service.getModel(this.client.getEndpoint(), modelId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getModelAsync(String modelId) {
        return this.getModelWithResponseAsync(modelId).flatMap(res -> Mono.justOrEmpty((Object)((DocumentModelDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getModelAsync(String modelId, Context context) {
        return this.getModelWithResponseAsync(modelId, context).flatMap(res -> Mono.justOrEmpty((Object)((DocumentModelDetails)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DocumentModelDetails> getModelWithResponse(String modelId, Context context) {
        String accept = "application/json";
        return this.service.getModelSync(this.client.getEndpoint(), modelId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentModelDetails getModel(String modelId) {
        return (DocumentModelDetails)this.getModelWithResponse(modelId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId) {
        return FluxUtil.withContext(context -> this.deleteModelWithResponseAsync(modelId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId, Context context) {
        String accept = "application/json";
        return this.service.deleteModel(this.client.getEndpoint(), modelId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteModelAsync(String modelId) {
        return this.deleteModelWithResponseAsync(modelId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteModelAsync(String modelId, Context context) {
        return this.deleteModelWithResponseAsync(modelId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, Context context) {
        String accept = "application/json";
        return this.service.deleteModelSync(this.client.getEndpoint(), modelId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        this.deleteModelWithResponse(modelId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listModelsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> listModelsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listModelsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<GetDocumentModelsResponse> res = this.service.listModelsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> listModelsNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<GetDocumentModelsResponse> res = this.service.listModelsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetDocumentModelsResponse)res.getValue()).getValue(), ((GetDocumentModelsResponse)res.getValue()).getNextLink(), null);
    }

    @Host(value="{endpoint}/formrecognizer")
    @ServiceInterface(name="FormRecognizerClient")
    public static interface DocumentModelsService {
        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @BodyParam(value="application/json") AnalyzeDocumentRequest var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @BodyParam(value="application/json") AnalyzeDocumentRequest var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @BodyParam(value="application/json") AnalyzeDocumentRequest var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> analyzeDocumentNoCustomHeadersSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @BodyParam(value="application/json") AnalyzeDocumentRequest var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @HeaderParam(value="Content-Type") ContentType var8, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var9, @HeaderParam(value="Content-Length") Long var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @HeaderParam(value="Content-Type") ContentType var8, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var9, @HeaderParam(value="Content-Length") Long var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @HeaderParam(value="Content-Type") ContentType var8, @BodyParam(value="application/octet-stream") BinaryData var9, @HeaderParam(value="Content-Length") Long var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @HeaderParam(value="Content-Type") ContentType var8, @BodyParam(value="application/octet-stream") BinaryData var9, @HeaderParam(value="Content-Length") Long var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @HeaderParam(value="Content-Type") ContentType var8, @BodyParam(value="application/octet-stream") BinaryData var9, @HeaderParam(value="Content-Length") Long var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> analyzeDocumentNoCustomHeadersSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @HeaderParam(value="Content-Type") ContentType var8, @BodyParam(value="application/octet-stream") BinaryData var9, @HeaderParam(value="Content-Length") Long var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @BodyParam(value="text/html") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @BodyParam(value="text/html") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentModelsAnalyzeDocumentHeaders, Void> analyzeDocumentSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @BodyParam(value="text/html") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> analyzeDocumentNoCustomHeadersSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="locale") String var4, @QueryParam(value="stringIndexType") StringIndexType var5, @QueryParam(value="api-version") String var6, @QueryParam(value="features") String var7, @BodyParam(value="text/html") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeResultOperation>> getAnalyzeResult(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @PathParam(value="resultId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<AnalyzeResultOperation> getAnalyzeResultSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @PathParam(value="resultId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/documentModels:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentModelsBuildModelHeaders, Void>> buildModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BuildDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> buildModelNoCustomHeaders(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BuildDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentModelsBuildModelHeaders, Void> buildModelSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BuildDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:build")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> buildModelNoCustomHeadersSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") BuildDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:compose")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentModelsComposeModelHeaders, Void>> composeModel(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") ComposeDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:compose")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> composeModelNoCustomHeaders(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") ComposeDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:compose")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentModelsComposeModelHeaders, Void> composeModelSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") ComposeDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:compose")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> composeModelNoCustomHeadersSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") ComposeDocumentModelRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:authorizeCopy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<CopyAuthorization>> authorizeModelCopy(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") AuthorizeCopyRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels:authorizeCopy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<CopyAuthorization> authorizeModelCopySync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") AuthorizeCopyRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/documentModels/{modelId}:copyTo")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<DocumentModelsCopyModelToHeaders, Void>> copyModelTo(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CopyAuthorization var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/documentModels/{modelId}:copyTo")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> copyModelToNoCustomHeaders(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CopyAuthorization var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/documentModels/{modelId}:copyTo")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public ResponseBase<DocumentModelsCopyModelToHeaders, Void> copyModelToSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CopyAuthorization var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/documentModels/{modelId}:copyTo")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> copyModelToNoCustomHeadersSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CopyAuthorization var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/documentModels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetDocumentModelsResponse>> listModels(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/documentModels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetDocumentModelsResponse> listModelsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/documentModels/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<DocumentModelDetails>> getModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/documentModels/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<DocumentModelDetails> getModelSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/documentModels/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> deleteModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/documentModels/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> deleteModelSync(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<GetDocumentModelsResponse>> listModelsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<GetDocumentModelsResponse> listModelsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

