/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AzureBlobContentSource;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AzureBlobFileListContentSource;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentBuildMode;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public final class BuildDocumentModelRequest
implements JsonSerializable<BuildDocumentModelRequest> {
    private final String modelId;
    private String description;
    private final DocumentBuildMode buildMode;
    private AzureBlobContentSource azureBlobSource;
    private AzureBlobFileListContentSource azureBlobFileListSource;
    private Map<String, String> tags;

    public BuildDocumentModelRequest(String modelId, DocumentBuildMode buildMode) {
        this.modelId = modelId;
        this.buildMode = buildMode;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDescription() {
        return this.description;
    }

    public BuildDocumentModelRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    public BuildDocumentModelRequest setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    public BuildDocumentModelRequest setAzureBlobFileListSource(AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public BuildDocumentModelRequest setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("buildMode", this.buildMode == null ? null : this.buildMode.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("azureBlobSource", (JsonSerializable)this.azureBlobSource);
        jsonWriter.writeJsonField("azureBlobFileListSource", (JsonSerializable)this.azureBlobFileListSource);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BuildDocumentModelRequest fromJson(JsonReader jsonReader) throws IOException {
        return (BuildDocumentModelRequest)jsonReader.readObject(reader -> {
            boolean modelIdFound = false;
            String modelId = null;
            boolean buildModeFound = false;
            DocumentBuildMode buildMode = null;
            String description = null;
            AzureBlobContentSource azureBlobSource = null;
            AzureBlobFileListContentSource azureBlobFileListSource = null;
            Map tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    modelIdFound = true;
                    continue;
                }
                if ("buildMode".equals(fieldName)) {
                    buildMode = DocumentBuildMode.fromString(reader.getString());
                    buildModeFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("azureBlobSource".equals(fieldName)) {
                    azureBlobSource = AzureBlobContentSource.fromJson(reader);
                    continue;
                }
                if ("azureBlobFileListSource".equals(fieldName)) {
                    azureBlobFileListSource = AzureBlobFileListContentSource.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (modelIdFound && buildModeFound) {
                BuildDocumentModelRequest deserializedBuildDocumentModelRequest = new BuildDocumentModelRequest(modelId, buildMode);
                deserializedBuildDocumentModelRequest.description = description;
                deserializedBuildDocumentModelRequest.azureBlobSource = azureBlobSource;
                deserializedBuildDocumentModelRequest.azureBlobFileListSource = azureBlobFileListSource;
                deserializedBuildDocumentModelRequest.tags = tags;
                return deserializedBuildDocumentModelRequest;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!modelIdFound) {
                missingProperties.add("modelId");
            }
            if (!buildModeFound) {
                missingProperties.add("buildMode");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

