/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentFormulaKind;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentFormula
implements JsonSerializable<DocumentFormula> {
    private final DocumentFormulaKind kind;
    private final String value;
    private List<Float> polygon;
    private final DocumentSpan span;
    private final float confidence;

    public DocumentFormula(DocumentFormulaKind kind, String value, DocumentSpan span, float confidence) {
        this.kind = kind;
        this.value = value;
        this.span = span;
        this.confidence = confidence;
    }

    public DocumentFormulaKind getKind() {
        return this.kind;
    }

    public String getValue() {
        return this.value;
    }

    public List<Float> getPolygon() {
        return this.polygon;
    }

    public DocumentFormula setPolygon(List<Float> polygon) {
        this.polygon = polygon;
        return this;
    }

    public DocumentSpan getSpan() {
        return this.span;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeJsonField("span", (JsonSerializable)this.span);
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeFloat(element.floatValue()));
        return jsonWriter.writeEndObject();
    }

    public static DocumentFormula fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentFormula)jsonReader.readObject(reader -> {
            boolean kindFound = false;
            DocumentFormulaKind kind = null;
            boolean valueFound = false;
            String value = null;
            boolean spanFound = false;
            DocumentSpan span = null;
            boolean confidenceFound = false;
            float confidence = 0.0f;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    kind = DocumentFormulaKind.fromString(reader.getString());
                    kindFound = true;
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = reader.getString();
                    valueFound = true;
                    continue;
                }
                if ("span".equals(fieldName)) {
                    span = DocumentSpan.fromJson(reader);
                    spanFound = true;
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getFloat();
                    confidenceFound = true;
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                reader.skipChildren();
            }
            if (kindFound && valueFound && spanFound && confidenceFound) {
                DocumentFormula deserializedDocumentFormula = new DocumentFormula(kind, value, span, confidence);
                deserializedDocumentFormula.polygon = polygon;
                return deserializedDocumentFormula;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!kindFound) {
                missingProperties.add("kind");
            }
            if (!valueFound) {
                missingProperties.add("value");
            }
            if (!spanFound) {
                missingProperties.add("span");
            }
            if (!confidenceFound) {
                missingProperties.add("confidence");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

