/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BoundingRegion;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentKeyValueElement
implements JsonSerializable<DocumentKeyValueElement> {
    private final String content;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;

    public DocumentKeyValueElement(String content, List<DocumentSpan> spans) {
        this.content = content;
        this.spans = spans;
    }

    public String getContent() {
        return this.content;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public DocumentKeyValueElement setBoundingRegions(List<BoundingRegion> boundingRegions) {
        this.boundingRegions = boundingRegions;
        return this;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentKeyValueElement fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentKeyValueElement)jsonReader.readObject(reader -> {
            boolean contentFound = false;
            String content = null;
            boolean spansFound = false;
            List spans = null;
            List boundingRegions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    contentFound = true;
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (contentFound && spansFound) {
                DocumentKeyValueElement deserializedDocumentKeyValueElement = new DocumentKeyValueElement(content, spans);
                deserializedDocumentKeyValueElement.boundingRegions = boundingRegions;
                return deserializedDocumentKeyValueElement;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!contentFound) {
                missingProperties.add("content");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

