/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentLanguage
implements JsonSerializable<DocumentLanguage> {
    private final String locale;
    private final List<DocumentSpan> spans;
    private final float confidence;

    public DocumentLanguage(String locale, List<DocumentSpan> spans, float confidence) {
        this.locale = locale;
        this.spans = spans;
        this.confidence = confidence;
    }

    public String getLocale() {
        return this.locale;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("locale", this.locale);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeFloatField("confidence", this.confidence);
        return jsonWriter.writeEndObject();
    }

    public static DocumentLanguage fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentLanguage)jsonReader.readObject(reader -> {
            boolean localeFound = false;
            String locale = null;
            boolean spansFound = false;
            List spans = null;
            boolean confidenceFound = false;
            float confidence = 0.0f;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("locale".equals(fieldName)) {
                    locale = reader.getString();
                    localeFound = true;
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getFloat();
                    confidenceFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (localeFound && spansFound && confidenceFound) {
                return new DocumentLanguage(locale, spans, confidence);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!localeFound) {
                missingProperties.add("locale");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }
            if (!confidenceFound) {
                missingProperties.add("confidence");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

