/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;

public final class DocumentModelSummary
implements JsonSerializable<DocumentModelSummary> {
    private final String modelId;
    private String description;
    private final OffsetDateTime createdDateTime;
    private OffsetDateTime expirationDateTime;
    private String apiVersion;
    private Map<String, String> tags;

    public DocumentModelSummary(String modelId, OffsetDateTime createdDateTime) {
        this.modelId = modelId;
        this.createdDateTime = createdDateTime;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentModelSummary setDescription(String description) {
        this.description = description;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public DocumentModelSummary setExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public DocumentModelSummary setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public DocumentModelSummary setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentModelSummary fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentModelSummary)jsonReader.readObject(reader -> {
            boolean modelIdFound = false;
            String modelId = null;
            boolean createdDateTimeFound = false;
            OffsetDateTime createdDateTime = null;
            String description = null;
            OffsetDateTime expirationDateTime = null;
            String apiVersion = null;
            Map tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    modelIdFound = true;
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    createdDateTimeFound = true;
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (modelIdFound && createdDateTimeFound) {
                DocumentModelSummary deserializedDocumentModelSummary = new DocumentModelSummary(modelId, createdDateTime);
                deserializedDocumentModelSummary.description = description;
                deserializedDocumentModelSummary.expirationDateTime = expirationDateTime;
                deserializedDocumentModelSummary.apiVersion = apiVersion;
                deserializedDocumentModelSummary.tags = tags;
                return deserializedDocumentModelSummary;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!modelIdFound) {
                missingProperties.add("modelId");
            }
            if (!createdDateTimeFound) {
                missingProperties.add("createdDateTime");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

