/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentBarcode;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentFormula;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentLine;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSelectionMark;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentWord;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.LengthUnit;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentPage
implements JsonSerializable<DocumentPage> {
    private final int pageNumber;
    private Float angle;
    private Float width;
    private Float height;
    private LengthUnit unit;
    private final List<DocumentSpan> spans;
    private List<DocumentWord> words;
    private List<DocumentSelectionMark> selectionMarks;
    private List<DocumentLine> lines;
    private List<DocumentBarcode> barcodes;
    private List<DocumentFormula> formulas;

    public DocumentPage(int pageNumber, List<DocumentSpan> spans) {
        this.pageNumber = pageNumber;
        this.spans = spans;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Float getAngle() {
        return this.angle;
    }

    public DocumentPage setAngle(Float angle) {
        this.angle = angle;
        return this;
    }

    public Float getWidth() {
        return this.width;
    }

    public DocumentPage setWidth(Float width) {
        this.width = width;
        return this;
    }

    public Float getHeight() {
        return this.height;
    }

    public DocumentPage setHeight(Float height) {
        this.height = height;
        return this;
    }

    public LengthUnit getUnit() {
        return this.unit;
    }

    public DocumentPage setUnit(LengthUnit unit) {
        this.unit = unit;
        return this;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public List<DocumentWord> getWords() {
        return this.words;
    }

    public DocumentPage setWords(List<DocumentWord> words) {
        this.words = words;
        return this;
    }

    public List<DocumentSelectionMark> getSelectionMarks() {
        return this.selectionMarks;
    }

    public DocumentPage setSelectionMarks(List<DocumentSelectionMark> selectionMarks) {
        this.selectionMarks = selectionMarks;
        return this;
    }

    public List<DocumentLine> getLines() {
        return this.lines;
    }

    public DocumentPage setLines(List<DocumentLine> lines) {
        this.lines = lines;
        return this;
    }

    public List<DocumentBarcode> getBarcodes() {
        return this.barcodes;
    }

    public DocumentPage setBarcodes(List<DocumentBarcode> barcodes) {
        this.barcodes = barcodes;
        return this;
    }

    public List<DocumentFormula> getFormulas() {
        return this.formulas;
    }

    public DocumentPage setFormulas(List<DocumentFormula> formulas) {
        this.formulas = formulas;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("pageNumber", this.pageNumber);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("angle", (Number)this.angle);
        jsonWriter.writeNumberField("width", (Number)this.width);
        jsonWriter.writeNumberField("height", (Number)this.height);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("words", this.words, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("selectionMarks", this.selectionMarks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("lines", this.lines, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("barcodes", this.barcodes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("formulas", this.formulas, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentPage fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentPage)jsonReader.readObject(reader -> {
            boolean pageNumberFound = false;
            int pageNumber = 0;
            boolean spansFound = false;
            List spans = null;
            Float angle = null;
            Float width = null;
            Float height = null;
            LengthUnit unit = null;
            List words = null;
            List selectionMarks = null;
            List lines = null;
            List barcodes = null;
            List formulas = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pageNumber".equals(fieldName)) {
                    pageNumber = reader.getInt();
                    pageNumberFound = true;
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                    continue;
                }
                if ("angle".equals(fieldName)) {
                    angle = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("width".equals(fieldName)) {
                    width = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("height".equals(fieldName)) {
                    height = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    unit = LengthUnit.fromString(reader.getString());
                    continue;
                }
                if ("words".equals(fieldName)) {
                    words = reader.readArray(reader1 -> DocumentWord.fromJson(reader1));
                    continue;
                }
                if ("selectionMarks".equals(fieldName)) {
                    selectionMarks = reader.readArray(reader1 -> DocumentSelectionMark.fromJson(reader1));
                    continue;
                }
                if ("lines".equals(fieldName)) {
                    lines = reader.readArray(reader1 -> DocumentLine.fromJson(reader1));
                    continue;
                }
                if ("barcodes".equals(fieldName)) {
                    barcodes = reader.readArray(reader1 -> DocumentBarcode.fromJson(reader1));
                    continue;
                }
                if ("formulas".equals(fieldName)) {
                    formulas = reader.readArray(reader1 -> DocumentFormula.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (pageNumberFound && spansFound) {
                DocumentPage deserializedDocumentPage = new DocumentPage(pageNumber, spans);
                deserializedDocumentPage.angle = angle;
                deserializedDocumentPage.width = width;
                deserializedDocumentPage.height = height;
                deserializedDocumentPage.unit = unit;
                deserializedDocumentPage.words = words;
                deserializedDocumentPage.selectionMarks = selectionMarks;
                deserializedDocumentPage.lines = lines;
                deserializedDocumentPage.barcodes = barcodes;
                deserializedDocumentPage.formulas = formulas;
                return deserializedDocumentPage;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!pageNumberFound) {
                missingProperties.add("pageNumber");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

