/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BoundingRegion;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.models.ParagraphRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentParagraph
implements JsonSerializable<DocumentParagraph> {
    private ParagraphRole role;
    private final String content;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;

    public DocumentParagraph(String content, List<DocumentSpan> spans) {
        this.content = content;
        this.spans = spans;
    }

    public ParagraphRole getRole() {
        return this.role;
    }

    public DocumentParagraph setRole(ParagraphRole role) {
        this.role = role;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public DocumentParagraph setBoundingRegions(List<BoundingRegion> boundingRegions) {
        this.boundingRegions = boundingRegions;
        return this;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentParagraph fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentParagraph)jsonReader.readObject(reader -> {
            boolean contentFound = false;
            String content = null;
            boolean spansFound = false;
            List spans = null;
            ParagraphRole role = null;
            List boundingRegions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    contentFound = true;
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ParagraphRole.fromString(reader.getString());
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (contentFound && spansFound) {
                DocumentParagraph deserializedDocumentParagraph = new DocumentParagraph(content, spans);
                deserializedDocumentParagraph.role = role;
                deserializedDocumentParagraph.boundingRegions = boundingRegions;
                return deserializedDocumentParagraph;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!contentFound) {
                missingProperties.add("content");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

