/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.InnerError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Error
implements JsonSerializable<Error> {
    private final String code;
    private final String message;
    private String target;
    private List<Error> details;
    private InnerError innererror;

    public Error(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTarget() {
        return this.target;
    }

    public Error setTarget(String target) {
        this.target = target;
        return this;
    }

    public List<Error> getDetails() {
        return this.details;
    }

    public Error setDetails(List<Error> details) {
        this.details = details;
        return this;
    }

    public InnerError getInnererror() {
        return this.innererror;
    }

    public Error setInnererror(InnerError innererror) {
        this.innererror = innererror;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("innererror", (JsonSerializable)this.innererror);
        return jsonWriter.writeEndObject();
    }

    public static Error fromJson(JsonReader jsonReader) throws IOException {
        return (Error)jsonReader.readObject(reader -> {
            boolean codeFound = false;
            String code = null;
            boolean messageFound = false;
            String message = null;
            String target = null;
            List details = null;
            InnerError innererror = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    codeFound = true;
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    messageFound = true;
                    continue;
                }
                if ("target".equals(fieldName)) {
                    target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> Error.fromJson(reader1));
                    continue;
                }
                if ("innererror".equals(fieldName)) {
                    innererror = InnerError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (codeFound && messageFound) {
                Error deserializedError = new Error(code, message);
                deserializedError.target = target;
                deserializedError.details = details;
                deserializedError.innererror = innererror;
                return deserializedError;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!codeFound) {
                missingProperties.add("code");
            }
            if (!messageFound) {
                missingProperties.add("message");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

