/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelBuildOperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelComposeOperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.Error;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;

public class OperationDetails
implements JsonSerializable<OperationDetails> {
    private String kind = "OperationDetails";
    private final String operationId;
    private final OperationStatus status;
    private Integer percentCompleted;
    private final OffsetDateTime createdDateTime;
    private final OffsetDateTime lastUpdatedDateTime;
    private final String resourceLocation;
    private String apiVersion;
    private Map<String, String> tags;
    private Error error;

    public OperationDetails(String operationId, OperationStatus status, OffsetDateTime createdDateTime, OffsetDateTime lastUpdatedDateTime, String resourceLocation) {
        this.operationId = operationId;
        this.status = status;
        this.createdDateTime = createdDateTime;
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        this.resourceLocation = resourceLocation;
    }

    public String getKind() {
        return this.kind;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    public OperationDetails setPercentCompleted(Integer percentCompleted) {
        this.percentCompleted = percentCompleted;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public OperationDetails setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public OperationDetails setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Error getError() {
        return this.error;
    }

    public OperationDetails setError(Error error) {
        this.error = error;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", this.operationId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeNumberField("percentCompleted", (Number)this.percentCompleted);
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static OperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (OperationDetails)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                OperationDetails operationDetails;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("documentModelBuild".equals(discriminatorValue)) {
                    operationDetails = DocumentModelBuildOperationDetails.fromJson(readerToUse.reset());
                    return operationDetails;
                }
                if ("documentModelCompose".equals(discriminatorValue)) {
                    operationDetails = DocumentModelComposeOperationDetails.fromJson(readerToUse.reset());
                    return operationDetails;
                }
                if ("documentModelCopyTo".equals(discriminatorValue)) {
                    operationDetails = DocumentModelCopyToOperationDetails.fromJson(readerToUse.reset());
                    return operationDetails;
                }
                if ("documentClassifierBuild".equals(discriminatorValue)) {
                    operationDetails = DocumentClassifierBuildOperationDetails.fromJson(readerToUse.reset());
                    return operationDetails;
                }
                operationDetails = OperationDetails.fromJsonKnownDiscriminator(readerToUse.reset());
                return operationDetails;
            }
        });
    }

    static OperationDetails fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (OperationDetails)jsonReader.readObject(reader -> {
            boolean operationIdFound = false;
            String operationId = null;
            boolean statusFound = false;
            OperationStatus status = null;
            boolean createdDateTimeFound = false;
            OffsetDateTime createdDateTime = null;
            boolean lastUpdatedDateTimeFound = false;
            OffsetDateTime lastUpdatedDateTime = null;
            boolean resourceLocationFound = false;
            String resourceLocation = null;
            String kind = null;
            Integer percentCompleted = null;
            String apiVersion = null;
            Map tags = null;
            Error error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    operationId = reader.getString();
                    operationIdFound = true;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = OperationStatus.fromString(reader.getString());
                    statusFound = true;
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    createdDateTimeFound = true;
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    lastUpdatedDateTimeFound = true;
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                    resourceLocationFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = reader.getString();
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = Error.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (operationIdFound && statusFound && createdDateTimeFound && lastUpdatedDateTimeFound && resourceLocationFound) {
                OperationDetails deserializedOperationDetails = new OperationDetails(operationId, status, createdDateTime, lastUpdatedDateTime, resourceLocation);
                deserializedOperationDetails.kind = kind;
                deserializedOperationDetails.percentCompleted = percentCompleted;
                deserializedOperationDetails.apiVersion = apiVersion;
                deserializedOperationDetails.tags = tags;
                deserializedOperationDetails.error = error;
                return deserializedOperationDetails;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!operationIdFound) {
                missingProperties.add("operationId");
            }
            if (!statusFound) {
                missingProperties.add("status");
            }
            if (!createdDateTimeFound) {
                missingProperties.add("createdDateTime");
            }
            if (!lastUpdatedDateTimeFound) {
                missingProperties.add("lastUpdatedDateTime");
            }
            if (!resourceLocationFound) {
                missingProperties.add("resourceLocation");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

