/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationKind;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;

public final class OperationSummary
implements JsonSerializable<OperationSummary> {
    private final String operationId;
    private final OperationStatus status;
    private Integer percentCompleted;
    private final OffsetDateTime createdDateTime;
    private final OffsetDateTime lastUpdatedDateTime;
    private final OperationKind kind;
    private final String resourceLocation;
    private String apiVersion;
    private Map<String, String> tags;

    public OperationSummary(String operationId, OperationStatus status, OffsetDateTime createdDateTime, OffsetDateTime lastUpdatedDateTime, OperationKind kind, String resourceLocation) {
        this.operationId = operationId;
        this.status = status;
        this.createdDateTime = createdDateTime;
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        this.kind = kind;
        this.resourceLocation = resourceLocation;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    public OperationSummary setPercentCompleted(Integer percentCompleted) {
        this.percentCompleted = percentCompleted;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public OperationKind getKind() {
        return this.kind;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public OperationSummary setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public OperationSummary setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", this.operationId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeNumberField("percentCompleted", (Number)this.percentCompleted);
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static OperationSummary fromJson(JsonReader jsonReader) throws IOException {
        return (OperationSummary)jsonReader.readObject(reader -> {
            boolean operationIdFound = false;
            String operationId = null;
            boolean statusFound = false;
            OperationStatus status = null;
            boolean createdDateTimeFound = false;
            OffsetDateTime createdDateTime = null;
            boolean lastUpdatedDateTimeFound = false;
            OffsetDateTime lastUpdatedDateTime = null;
            boolean kindFound = false;
            OperationKind kind = null;
            boolean resourceLocationFound = false;
            String resourceLocation = null;
            Integer percentCompleted = null;
            String apiVersion = null;
            Map tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    operationId = reader.getString();
                    operationIdFound = true;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = OperationStatus.fromString(reader.getString());
                    statusFound = true;
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    createdDateTimeFound = true;
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    lastUpdatedDateTimeFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = OperationKind.fromString(reader.getString());
                    kindFound = true;
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                    resourceLocationFound = true;
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (operationIdFound && statusFound && createdDateTimeFound && lastUpdatedDateTimeFound && kindFound && resourceLocationFound) {
                OperationSummary deserializedOperationSummary = new OperationSummary(operationId, status, createdDateTime, lastUpdatedDateTime, kind, resourceLocation);
                deserializedOperationSummary.percentCompleted = percentCompleted;
                deserializedOperationSummary.apiVersion = apiVersion;
                deserializedOperationSummary.tags = tags;
                return deserializedOperationSummary;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!operationIdFound) {
                missingProperties.add("operationId");
            }
            if (!statusFound) {
                missingProperties.add("status");
            }
            if (!createdDateTimeFound) {
                missingProperties.add("createdDateTime");
            }
            if (!lastUpdatedDateTimeFound) {
                missingProperties.add("lastUpdatedDateTime");
            }
            if (!kindFound) {
                missingProperties.add("kind");
            }
            if (!resourceLocationFound) {
                missingProperties.add("resourceLocation");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

