/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.util.DocumentLineHelper;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentWord;
import com.azure.ai.formrecognizer.documentanalysis.models.Point;
import java.util.ArrayList;
import java.util.List;

public final class DocumentLine {
    private String content;
    private List<Point> boundingPolygon;
    private List<DocumentSpan> spans = new ArrayList<DocumentSpan>();
    private List<DocumentWord> pageWords;

    public DocumentLine() {
        this.boundingPolygon = new ArrayList<Point>();
        this.pageWords = new ArrayList<DocumentWord>();
    }

    public String getContent() {
        return this.content;
    }

    private void setContent(String content) {
        this.content = content;
    }

    public List<Point> getBoundingPolygon() {
        return this.boundingPolygon;
    }

    private void setBoundingPolygon(List<Point> boundingPolygon) {
        this.boundingPolygon = boundingPolygon;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    private void setSpans(List<DocumentSpan> spans) {
        this.spans = spans;
    }

    private void setPageWords(List<DocumentWord> pageWords) {
        this.pageWords = pageWords;
    }

    public List<DocumentWord> getWords() {
        ArrayList<DocumentWord> containedWords = new ArrayList<DocumentWord>();
        this.pageWords.forEach(documentWord -> this.spans.forEach(documentSpan -> {
            if (documentWord.getSpan().getOffset() >= documentSpan.getOffset() && documentWord.getSpan().getOffset() + documentWord.getSpan().getLength() <= documentSpan.getOffset() + documentSpan.getLength()) {
                containedWords.add((DocumentWord)documentWord);
            }
        }));
        return containedWords;
    }

    static {
        DocumentLineHelper.setAccessor(new DocumentLineHelper.DocumentLineAccessor(){

            @Override
            public void setContent(DocumentLine documentLine, String content) {
                documentLine.setContent(content);
            }

            @Override
            public void setBoundingPolygon(DocumentLine documentLine, List<Point> boundingPolygon) {
                documentLine.setBoundingPolygon(boundingPolygon);
            }

            @Override
            public void setSpans(DocumentLine documentLine, List<DocumentSpan> spans) {
                documentLine.setSpans(spans);
            }

            @Override
            public void setPageWords(DocumentLine documentLine, List<DocumentWord> words) {
                documentLine.setPageWords(words);
            }
        });
    }
}

