/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeBusinessCardHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeIdDocumentHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeInvoiceHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeLayoutHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeReceiptHeaders;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.implementation.models.Language;
import com.azure.ai.formrecognizer.implementation.models.Locale;
import com.azure.ai.formrecognizer.implementation.models.ReadingOrder;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AnalyzersImpl {
    private final AnalyzersService service;
    private final FormRecognizerClientImpl client;

    AnalyzersImpl(FormRecognizerClientImpl client) {
        this.service = (AnalyzersService)RestProxy.create(AnalyzersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeBusinessCard(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void> analyzeBusinessCardWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeBusinessCard(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeBusinessCardWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeBusinessCardNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeBusinessCardNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeBusinessCardNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeBusinessCardNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeBusinessCard(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return this.analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return this.analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void> analyzeBusinessCardWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeBusinessCard(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        this.analyzeBusinessCardWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeBusinessCardNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeBusinessCardNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeBusinessCardNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeBusinessCardNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeBusinessCardWithResponseAsync(includeTextDetails, locale, pages, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeBusinessCard(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return this.analyzeBusinessCardWithResponseAsync(includeTextDetails, locale, pages, fileStream).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeBusinessCardWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void> analyzeBusinessCardWithResponse(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return (ResponseBase)this.analyzeBusinessCardWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeBusinessCard(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        this.analyzeBusinessCardWithResponse(includeTextDetails, locale, pages, fileStream, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeBusinessCardNoCustomHeadersWithResponseAsync(includeTextDetails, locale, pages, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeBusinessCardNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeBusinessCardNoCustomHeadersWithResponse(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return (Response)this.analyzeBusinessCardNoCustomHeadersWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> this.getAnalyzeBusinessCardResultWithResponseAsync(resultId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeBusinessCardResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeBusinessCardResultAsync(UUID resultId) {
        return this.getAnalyzeBusinessCardResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeBusinessCardResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeBusinessCardResultWithResponseAsync(resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeBusinessCardResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeBusinessCardResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeBusinessCardResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeBusinessCardResultWithResponse(resultId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeInvoice(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void> analyzeInvoiceWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeInvoice(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeInvoiceWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeInvoiceNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeInvoiceNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeInvoiceNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeInvoiceNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeInvoice(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return this.analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return this.analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void> analyzeInvoiceWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeInvoice(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        this.analyzeInvoiceWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeInvoiceNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeInvoiceNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeInvoiceNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeInvoiceNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeInvoiceWithResponseAsync(includeTextDetails, locale, pages, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeInvoice(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return this.analyzeInvoiceWithResponseAsync(includeTextDetails, locale, pages, fileStream).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeInvoiceWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void> analyzeInvoiceWithResponse(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return (ResponseBase)this.analyzeInvoiceWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeInvoice(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        this.analyzeInvoiceWithResponse(includeTextDetails, locale, pages, fileStream, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeInvoiceNoCustomHeadersWithResponseAsync(includeTextDetails, locale, pages, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeInvoiceNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeInvoiceNoCustomHeadersWithResponse(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return (Response)this.analyzeInvoiceNoCustomHeadersWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> this.getAnalyzeInvoiceResultWithResponseAsync(resultId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeInvoiceResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeInvoiceResultAsync(UUID resultId) {
        return this.getAnalyzeInvoiceResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeInvoiceResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeInvoiceResultWithResponseAsync(resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeInvoiceResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeInvoiceResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeInvoiceResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeInvoiceResultWithResponse(resultId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeIdDocument(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void> analyzeIdDocumentWithResponse(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeIdDocument(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeIdDocumentWithResponse(contentType, includeTextDetails, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeIdDocumentNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeIdDocumentNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeIdDocumentNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeIdDocumentNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeIdDocument(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength) {
        return this.analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return this.analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void> analyzeIdDocumentWithResponse(ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeIdDocument(ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength) {
        this.analyzeIdDocumentWithResponse(contentType, includeTextDetails, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeIdDocumentNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeIdDocumentNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeIdDocumentNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeIdDocumentNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeIdDocumentWithResponseAsync(includeTextDetails, pages, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeIdDocument(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return this.analyzeIdDocumentWithResponseAsync(includeTextDetails, pages, fileStream).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeIdDocumentWithResponseAsync(includeTextDetails, pages, fileStream, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void> analyzeIdDocumentWithResponse(Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return (ResponseBase)this.analyzeIdDocumentWithResponseAsync(includeTextDetails, pages, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeIdDocument(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        this.analyzeIdDocumentWithResponse(includeTextDetails, pages, fileStream, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeIdDocumentNoCustomHeadersWithResponseAsync(includeTextDetails, pages, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeIdDocumentNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeIdDocumentNoCustomHeadersWithResponse(Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return (Response)this.analyzeIdDocumentNoCustomHeadersWithResponseAsync(includeTextDetails, pages, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> this.getAnalyzeIdDocumentResultWithResponseAsync(resultId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeIdDocumentResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeIdDocumentResultAsync(UUID resultId) {
        return this.getAnalyzeIdDocumentResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeIdDocumentResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeIdDocumentResultWithResponseAsync(resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeIdDocumentResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeIdDocumentResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeIdDocumentResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeIdDocumentResultWithResponse(resultId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeReceipt(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void> analyzeReceiptWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeReceipt(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeReceiptWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeReceiptNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeReceiptNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeReceiptNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeReceiptNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeReceipt(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return this.analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return this.analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void> analyzeReceiptWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeReceipt(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        this.analyzeReceiptWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeReceiptNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeReceiptNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeReceiptNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeReceiptNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeReceiptWithResponseAsync(includeTextDetails, locale, pages, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeReceipt(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return this.analyzeReceiptWithResponseAsync(includeTextDetails, locale, pages, fileStream).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return this.analyzeReceiptWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void> analyzeReceiptWithResponse(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return (ResponseBase)this.analyzeReceiptWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeReceipt(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        this.analyzeReceiptWithResponse(includeTextDetails, locale, pages, fileStream, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeReceiptNoCustomHeadersWithResponseAsync(includeTextDetails, locale, pages, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeReceiptNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails, locale, pagesConverted, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeReceiptNoCustomHeadersWithResponse(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return (Response)this.analyzeReceiptNoCustomHeadersWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> this.getAnalyzeReceiptResultWithResponseAsync(resultId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeReceiptResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeReceiptResultAsync(UUID resultId) {
        return this.getAnalyzeReceiptResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeReceiptResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeReceiptResultWithResponseAsync(resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeReceiptResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeReceiptResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeReceiptResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeReceiptResultWithResponse(resultId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeLayout(this.client.getEndpoint(), this.client.getApiVersion(), pagesConverted, language, readingOrder, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength) {
        return this.analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return this.analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void> analyzeLayoutWithResponse(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeLayout(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength) {
        this.analyzeLayoutWithResponse(contentType, pages, language, readingOrder, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeLayoutNoCustomHeadersWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeLayoutNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), pagesConverted, language, readingOrder, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeLayoutNoCustomHeadersWithResponse(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeLayoutNoCustomHeadersWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeLayout(this.client.getEndpoint(), this.client.getApiVersion(), pagesConverted, language, readingOrder, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength) {
        return this.analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength, Context context) {
        return this.analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void> analyzeLayoutWithResponse(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength, Context context) {
        return (ResponseBase)this.analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeLayout(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength) {
        this.analyzeLayoutWithResponse(contentType, pages, language, readingOrder, fileStream, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> this.analyzeLayoutNoCustomHeadersWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeLayoutNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), pagesConverted, language, readingOrder, contentType, fileStream, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeLayoutNoCustomHeadersWithResponse(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength, Context context) {
        return (Response)this.analyzeLayoutNoCustomHeadersWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeLayoutWithResponseAsync(pages, language, readingOrder, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeLayout(this.client.getEndpoint(), this.client.getApiVersion(), pagesConverted, language, readingOrder, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        return this.analyzeLayoutWithResponseAsync(pages, language, readingOrder, fileStream).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        return this.analyzeLayoutWithResponseAsync(pages, language, readingOrder, fileStream, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void> analyzeLayoutWithResponse(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        return (ResponseBase)this.analyzeLayoutWithResponseAsync(pages, language, readingOrder, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void analyzeLayout(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        this.analyzeLayoutWithResponse(pages, language, readingOrder, fileStream, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.analyzeLayoutNoCustomHeadersWithResponseAsync(pages, language, readingOrder, fileStream, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        String accept = "application/json";
        String pagesConverted = pages == null ? null : pages.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return this.service.analyzeLayoutNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), pagesConverted, language, readingOrder, fileStream, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> analyzeLayoutNoCustomHeadersWithResponse(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        return (Response)this.analyzeLayoutNoCustomHeadersWithResponseAsync(pages, language, readingOrder, fileStream, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> this.getAnalyzeLayoutResultWithResponseAsync(resultId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(UUID resultId, Context context) {
        String accept = "application/json";
        return this.service.getAnalyzeLayoutResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeLayoutResultAsync(UUID resultId) {
        return this.getAnalyzeLayoutResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeLayoutResultAsync(UUID resultId, Context context) {
        return this.getAnalyzeLayoutResultWithResponseAsync(resultId, context).flatMap(res -> Mono.justOrEmpty((Object)((AnalyzeOperationResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeLayoutResultWithResponse(UUID resultId, Context context) {
        return (Response)this.getAnalyzeLayoutResultWithResponseAsync(resultId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeLayoutResult(UUID resultId) {
        return (AnalyzeOperationResult)this.getAnalyzeLayoutResultWithResponse(resultId, Context.NONE).getValue();
    }

    @Host(value="{endpoint}/formrecognizer/{ApiVersion}")
    @ServiceInterface(name="FormRecognizerClient")
    public static interface AnalyzersService {
        @Post(value="/prebuilt/businessCard/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCard(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/businessCard/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeBusinessCardNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/businessCard/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCard(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") BinaryData var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/businessCard/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeBusinessCardNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") BinaryData var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/businessCard/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCard(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/prebuilt/businessCard/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeBusinessCardNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/prebuilt/businessCard/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/prebuilt/invoice/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoice(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/invoice/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeInvoiceNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/invoice/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoice(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") BinaryData var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/invoice/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeInvoiceNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") BinaryData var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/invoice/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoice(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/prebuilt/invoice/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeInvoiceNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/prebuilt/invoice/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/prebuilt/idDocument/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocument(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="pages") String var4, @HeaderParam(value="Content-Type") ContentType var5, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/prebuilt/idDocument/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeIdDocumentNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="pages") String var4, @HeaderParam(value="Content-Type") ContentType var5, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/prebuilt/idDocument/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocument(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="pages") String var4, @HeaderParam(value="Content-Type") ContentType var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/prebuilt/idDocument/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeIdDocumentNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="pages") String var4, @HeaderParam(value="Content-Type") ContentType var5, @BodyParam(value="application/octet-stream") BinaryData var6, @HeaderParam(value="Content-Length") Long var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/prebuilt/idDocument/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocument(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="pages") String var4, @BodyParam(value="application/json") SourcePath var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/prebuilt/idDocument/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeIdDocumentNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="pages") String var4, @BodyParam(value="application/json") SourcePath var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/prebuilt/idDocument/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceipt(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeReceiptNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceipt(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") BinaryData var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeReceiptNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") BinaryData var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceipt(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeReceiptNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="includeTextDetails") Boolean var3, @QueryParam(value="locale") Locale var4, @QueryParam(value="pages") String var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/prebuilt/receipt/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayout(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="language") Language var4, @QueryParam(value="readingOrder") ReadingOrder var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeLayoutNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="language") Language var4, @QueryParam(value="readingOrder") ReadingOrder var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayout(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="language") Language var4, @QueryParam(value="readingOrder") ReadingOrder var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") BinaryData var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeLayoutNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="language") Language var4, @QueryParam(value="readingOrder") ReadingOrder var5, @HeaderParam(value="Content-Type") ContentType var6, @BodyParam(value="application/octet-stream") BinaryData var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayout(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="language") Language var4, @QueryParam(value="readingOrder") ReadingOrder var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> analyzeLayoutNoCustomHeaders(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @QueryParam(value="pages") String var3, @QueryParam(value="language") Language var4, @QueryParam(value="readingOrder") ReadingOrder var5, @BodyParam(value="application/json") SourcePath var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/layout/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResult(@HostParam(value="endpoint") String var1, @HostParam(value="ApiVersion") String var2, @PathParam(value="resultId") UUID var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

