/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.ErrorInformation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class CopyResult
implements JsonSerializable<CopyResult> {
    private UUID modelId;
    private List<ErrorInformation> errors;

    public UUID getModelId() {
        return this.modelId;
    }

    public CopyResult setModelId(UUID modelId) {
        this.modelId = modelId;
        return this;
    }

    public List<ErrorInformation> getErrors() {
        return this.errors;
    }

    public CopyResult setErrors(List<ErrorInformation> errors) {
        this.errors = errors;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", Objects.toString(this.modelId, null));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CopyResult fromJson(JsonReader jsonReader) throws IOException {
        return (CopyResult)jsonReader.readObject(reader -> {
            CopyResult deserializedCopyResult = new CopyResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    deserializedCopyResult.modelId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedCopyResult.errors = errors = reader.readArray(reader1 -> ErrorInformation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCopyResult;
        });
    }
}

