/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.FieldValueSelectionMark;
import com.azure.ai.formrecognizer.implementation.models.FieldValueType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class FieldValue
implements JsonSerializable<FieldValue> {
    private FieldValueType type;
    private String valueString;
    private LocalDate valueDate;
    private String valueTime;
    private String valuePhoneNumber;
    private Float valueNumber;
    private Integer valueInteger;
    private List<FieldValue> valueArray;
    private Map<String, FieldValue> valueObject;
    private FieldValueSelectionMark valueSelectionMark;
    private String valueCountryRegion;
    private String text;
    private List<Float> boundingBox;
    private Float confidence;
    private List<String> elements;
    private Integer page;

    public FieldValueType getType() {
        return this.type;
    }

    public FieldValue setType(FieldValueType type) {
        this.type = type;
        return this;
    }

    public String getValueString() {
        return this.valueString;
    }

    public FieldValue setValueString(String valueString) {
        this.valueString = valueString;
        return this;
    }

    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public FieldValue setValueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    public String getValueTime() {
        return this.valueTime;
    }

    public FieldValue setValueTime(String valueTime) {
        this.valueTime = valueTime;
        return this;
    }

    public String getValuePhoneNumber() {
        return this.valuePhoneNumber;
    }

    public FieldValue setValuePhoneNumber(String valuePhoneNumber) {
        this.valuePhoneNumber = valuePhoneNumber;
        return this;
    }

    public Float getValueNumber() {
        return this.valueNumber;
    }

    public FieldValue setValueNumber(Float valueNumber) {
        this.valueNumber = valueNumber;
        return this;
    }

    public Integer getValueInteger() {
        return this.valueInteger;
    }

    public FieldValue setValueInteger(Integer valueInteger) {
        this.valueInteger = valueInteger;
        return this;
    }

    public List<FieldValue> getValueArray() {
        return this.valueArray;
    }

    public FieldValue setValueArray(List<FieldValue> valueArray) {
        this.valueArray = valueArray;
        return this;
    }

    public Map<String, FieldValue> getValueObject() {
        return this.valueObject;
    }

    public FieldValue setValueObject(Map<String, FieldValue> valueObject) {
        this.valueObject = valueObject;
        return this;
    }

    public FieldValueSelectionMark getValueSelectionMark() {
        return this.valueSelectionMark;
    }

    public FieldValue setValueSelectionMark(FieldValueSelectionMark valueSelectionMark) {
        this.valueSelectionMark = valueSelectionMark;
        return this;
    }

    public String getValueCountryRegion() {
        return this.valueCountryRegion;
    }

    public FieldValue setValueCountryRegion(String valueCountryRegion) {
        this.valueCountryRegion = valueCountryRegion;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public FieldValue setText(String text) {
        this.text = text;
        return this;
    }

    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    public FieldValue setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public FieldValue setConfidence(Float confidence) {
        this.confidence = confidence;
        return this;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public FieldValue setElements(List<String> elements) {
        this.elements = elements;
        return this;
    }

    public Integer getPage() {
        return this.page;
    }

    public FieldValue setPage(Integer page) {
        this.page = page;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("valueString", this.valueString);
        jsonWriter.writeStringField("valueDate", Objects.toString(this.valueDate, null));
        jsonWriter.writeStringField("valueTime", this.valueTime);
        jsonWriter.writeStringField("valuePhoneNumber", this.valuePhoneNumber);
        jsonWriter.writeNumberField("valueNumber", (Number)this.valueNumber);
        jsonWriter.writeNumberField("valueInteger", (Number)this.valueInteger);
        jsonWriter.writeArrayField("valueArray", this.valueArray, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("valueObject", this.valueObject, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("valueSelectionMark", this.valueSelectionMark == null ? null : this.valueSelectionMark.toString());
        jsonWriter.writeStringField("valueCountryRegion", this.valueCountryRegion);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("boundingBox", this.boundingBox, (writer, element) -> writer.writeFloat(element.floatValue()));
        jsonWriter.writeNumberField("confidence", (Number)this.confidence);
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("page", (Number)this.page);
        return jsonWriter.writeEndObject();
    }

    public static FieldValue fromJson(JsonReader jsonReader) throws IOException {
        return (FieldValue)jsonReader.readObject(reader -> {
            FieldValue deserializedFieldValue = new FieldValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedFieldValue.type = FieldValueType.fromString(reader.getString());
                    continue;
                }
                if ("valueString".equals(fieldName)) {
                    deserializedFieldValue.valueString = reader.getString();
                    continue;
                }
                if ("valueDate".equals(fieldName)) {
                    deserializedFieldValue.valueDate = (LocalDate)reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                    continue;
                }
                if ("valueTime".equals(fieldName)) {
                    deserializedFieldValue.valueTime = reader.getString();
                    continue;
                }
                if ("valuePhoneNumber".equals(fieldName)) {
                    deserializedFieldValue.valuePhoneNumber = reader.getString();
                    continue;
                }
                if ("valueNumber".equals(fieldName)) {
                    deserializedFieldValue.valueNumber = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("valueInteger".equals(fieldName)) {
                    deserializedFieldValue.valueInteger = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("valueArray".equals(fieldName)) {
                    List valueArray;
                    deserializedFieldValue.valueArray = valueArray = reader.readArray(reader1 -> FieldValue.fromJson(reader1));
                    continue;
                }
                if ("valueObject".equals(fieldName)) {
                    Map valueObject;
                    deserializedFieldValue.valueObject = valueObject = reader.readMap(reader1 -> FieldValue.fromJson(reader1));
                    continue;
                }
                if ("valueSelectionMark".equals(fieldName)) {
                    deserializedFieldValue.valueSelectionMark = FieldValueSelectionMark.fromString(reader.getString());
                    continue;
                }
                if ("valueCountryRegion".equals(fieldName)) {
                    deserializedFieldValue.valueCountryRegion = reader.getString();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    deserializedFieldValue.text = reader.getString();
                    continue;
                }
                if ("boundingBox".equals(fieldName)) {
                    List boundingBox;
                    deserializedFieldValue.boundingBox = boundingBox = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    deserializedFieldValue.confidence = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("elements".equals(fieldName)) {
                    List elements;
                    deserializedFieldValue.elements = elements = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("page".equals(fieldName)) {
                    deserializedFieldValue.page = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFieldValue;
        });
    }
}

