/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.KeyValueElement;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class KeyValuePair
implements JsonSerializable<KeyValuePair> {
    private String label;
    private KeyValueElement key;
    private KeyValueElement value;
    private float confidence;

    public String getLabel() {
        return this.label;
    }

    public KeyValuePair setLabel(String label) {
        this.label = label;
        return this;
    }

    public KeyValueElement getKey() {
        return this.key;
    }

    public KeyValuePair setKey(KeyValueElement key) {
        this.key = key;
        return this;
    }

    public KeyValueElement getValue() {
        return this.value;
    }

    public KeyValuePair setValue(KeyValueElement value) {
        this.value = value;
        return this;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public KeyValuePair setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", (JsonSerializable)this.key);
        jsonWriter.writeJsonField("value", (JsonSerializable)this.value);
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeStringField("label", this.label);
        return jsonWriter.writeEndObject();
    }

    public static KeyValuePair fromJson(JsonReader jsonReader) throws IOException {
        return (KeyValuePair)jsonReader.readObject(reader -> {
            KeyValuePair deserializedKeyValuePair = new KeyValuePair();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedKeyValuePair.key = KeyValueElement.fromJson(reader);
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedKeyValuePair.value = KeyValueElement.fromJson(reader);
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    deserializedKeyValuePair.confidence = reader.getFloat();
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedKeyValuePair.label = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyValuePair;
        });
    }
}

