/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.Attributes;
import com.azure.ai.formrecognizer.implementation.models.ModelStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;

public final class ModelInfo
implements JsonSerializable<ModelInfo> {
    private UUID modelId;
    private ModelStatus status;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime lastUpdatedDateTime;
    private String modelName;
    private Attributes attributes;

    public UUID getModelId() {
        return this.modelId;
    }

    public ModelInfo setModelId(UUID modelId) {
        this.modelId = modelId;
        return this;
    }

    public ModelStatus getStatus() {
        return this.status;
    }

    public ModelInfo setStatus(ModelStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public ModelInfo setCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public ModelInfo setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    public String getModelName() {
        return this.modelName;
    }

    public ModelInfo setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public ModelInfo setAttributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", Objects.toString(this.modelId, null));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeStringField("modelName", this.modelName);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        return jsonWriter.writeEndObject();
    }

    public static ModelInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ModelInfo)jsonReader.readObject(reader -> {
            ModelInfo deserializedModelInfo = new ModelInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    deserializedModelInfo.modelId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedModelInfo.status = ModelStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedModelInfo.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedModelInfo.lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("modelName".equals(fieldName)) {
                    deserializedModelInfo.modelName = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedModelInfo.attributes = Attributes.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModelInfo;
        });
    }
}

