/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation.models;

import com.azure.ai.formrecognizer.implementation.models.TrainSourceFilter;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TrainRequest
implements JsonSerializable<TrainRequest> {
    private String source;
    private TrainSourceFilter sourceFilter;
    private Boolean useLabelFile;
    private String modelName;

    public String getSource() {
        return this.source;
    }

    public TrainRequest setSource(String source) {
        this.source = source;
        return this;
    }

    public TrainSourceFilter getSourceFilter() {
        return this.sourceFilter;
    }

    public TrainRequest setSourceFilter(TrainSourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
        return this;
    }

    public Boolean isUseLabelFile() {
        return this.useLabelFile;
    }

    public TrainRequest setUseLabelFile(Boolean useLabelFile) {
        this.useLabelFile = useLabelFile;
        return this;
    }

    public String getModelName() {
        return this.modelName;
    }

    public TrainRequest setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeJsonField("sourceFilter", (JsonSerializable)this.sourceFilter);
        jsonWriter.writeBooleanField("useLabelFile", this.useLabelFile);
        jsonWriter.writeStringField("modelName", this.modelName);
        return jsonWriter.writeEndObject();
    }

    public static TrainRequest fromJson(JsonReader jsonReader) throws IOException {
        return (TrainRequest)jsonReader.readObject(reader -> {
            TrainRequest deserializedTrainRequest = new TrainRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedTrainRequest.source = reader.getString();
                    continue;
                }
                if ("sourceFilter".equals(fieldName)) {
                    deserializedTrainRequest.sourceFilter = TrainSourceFilter.fromJson(reader);
                    continue;
                }
                if ("useLabelFile".equals(fieldName)) {
                    deserializedTrainRequest.useLabelFile = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("modelName".equals(fieldName)) {
                    deserializedTrainRequest.modelName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrainRequest;
        });
    }
}

