// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Document classification parameters.
 */
@Fluent
public final class ClassifyDocumentRequest implements JsonSerializable<ClassifyDocumentRequest> {
    /*
     * Document URL to classify. Either urlSource or base64Source must be specified.
     */
    private String urlSource;

    /*
     * Base64 encoding of the document to classify. Either urlSource or base64Source must be specified.
     */
    private byte[] base64Source;

    /**
     * Creates an instance of ClassifyDocumentRequest class.
     */
    public ClassifyDocumentRequest() {
    }

    /**
     * Get the urlSource property: Document URL to classify. Either urlSource or base64Source must be specified.
     * 
     * @return the urlSource value.
     */
    public String getUrlSource() {
        return this.urlSource;
    }

    /**
     * Set the urlSource property: Document URL to classify. Either urlSource or base64Source must be specified.
     * 
     * @param urlSource the urlSource value to set.
     * @return the ClassifyDocumentRequest object itself.
     */
    public ClassifyDocumentRequest setUrlSource(String urlSource) {
        this.urlSource = urlSource;
        return this;
    }

    /**
     * Get the base64Source property: Base64 encoding of the document to classify. Either urlSource or base64Source must
     * be specified.
     * 
     * @return the base64Source value.
     */
    public byte[] getBase64Source() {
        return CoreUtils.clone(this.base64Source);
    }

    /**
     * Set the base64Source property: Base64 encoding of the document to classify. Either urlSource or base64Source must
     * be specified.
     * 
     * @param base64Source the base64Source value to set.
     * @return the ClassifyDocumentRequest object itself.
     */
    public ClassifyDocumentRequest setBase64Source(byte[] base64Source) {
        this.base64Source = CoreUtils.clone(base64Source);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("urlSource", this.urlSource);
        jsonWriter.writeBinaryField("base64Source", this.base64Source);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClassifyDocumentRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClassifyDocumentRequest if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClassifyDocumentRequest.
     */
    public static ClassifyDocumentRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClassifyDocumentRequest deserializedClassifyDocumentRequest = new ClassifyDocumentRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("urlSource".equals(fieldName)) {
                    deserializedClassifyDocumentRequest.urlSource = reader.getString();
                } else if ("base64Source".equals(fieldName)) {
                    deserializedClassifyDocumentRequest.base64Source = reader.getBinary();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClassifyDocumentRequest;
        });
    }
}
