// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * Authorization to copy a document model to the specified target resource and modelId.
 */
@Immutable
public final class CopyAuthorization implements JsonSerializable<CopyAuthorization> {
    /*
     * ID of the target Azure resource where the document model should be copied to.
     */
    private final String targetResourceId;

    /*
     * Location of the target Azure resource where the document model should be copied to.
     */
    private final String targetResourceRegion;

    /*
     * Identifier of the target document model.
     */
    private final String targetModelId;

    /*
     * URL of the copied document model in the target account.
     */
    private final String targetModelLocation;

    /*
     * Token used to authorize the request.
     */
    private final String accessToken;

    /*
     * Date/time when the access token expires.
     */
    private final OffsetDateTime expirationDateTime;

    /**
     * Creates an instance of CopyAuthorization class.
     * 
     * @param targetResourceId the targetResourceId value to set.
     * @param targetResourceRegion the targetResourceRegion value to set.
     * @param targetModelId the targetModelId value to set.
     * @param targetModelLocation the targetModelLocation value to set.
     * @param accessToken the accessToken value to set.
     * @param expirationDateTime the expirationDateTime value to set.
     */
    public CopyAuthorization(String targetResourceId, String targetResourceRegion, String targetModelId,
        String targetModelLocation, String accessToken, OffsetDateTime expirationDateTime) {
        this.targetResourceId = targetResourceId;
        this.targetResourceRegion = targetResourceRegion;
        this.targetModelId = targetModelId;
        this.targetModelLocation = targetModelLocation;
        this.accessToken = accessToken;
        this.expirationDateTime = expirationDateTime;
    }

    /**
     * Get the targetResourceId property: ID of the target Azure resource where the document model should be copied to.
     * 
     * @return the targetResourceId value.
     */
    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Get the targetResourceRegion property: Location of the target Azure resource where the document model should be
     * copied to.
     * 
     * @return the targetResourceRegion value.
     */
    public String getTargetResourceRegion() {
        return this.targetResourceRegion;
    }

    /**
     * Get the targetModelId property: Identifier of the target document model.
     * 
     * @return the targetModelId value.
     */
    public String getTargetModelId() {
        return this.targetModelId;
    }

    /**
     * Get the targetModelLocation property: URL of the copied document model in the target account.
     * 
     * @return the targetModelLocation value.
     */
    public String getTargetModelLocation() {
        return this.targetModelLocation;
    }

    /**
     * Get the accessToken property: Token used to authorize the request.
     * 
     * @return the accessToken value.
     */
    public String getAccessToken() {
        return this.accessToken;
    }

    /**
     * Get the expirationDateTime property: Date/time when the access token expires.
     * 
     * @return the expirationDateTime value.
     */
    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("targetResourceRegion", this.targetResourceRegion);
        jsonWriter.writeStringField("targetModelId", this.targetModelId);
        jsonWriter.writeStringField("targetModelLocation", this.targetModelLocation);
        jsonWriter.writeStringField("accessToken", this.accessToken);
        jsonWriter.writeStringField("expirationDateTime",
            this.expirationDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CopyAuthorization from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CopyAuthorization if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CopyAuthorization.
     */
    public static CopyAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean targetResourceIdFound = false;
            String targetResourceId = null;
            boolean targetResourceRegionFound = false;
            String targetResourceRegion = null;
            boolean targetModelIdFound = false;
            String targetModelId = null;
            boolean targetModelLocationFound = false;
            String targetModelLocation = null;
            boolean accessTokenFound = false;
            String accessToken = null;
            boolean expirationDateTimeFound = false;
            OffsetDateTime expirationDateTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetResourceId".equals(fieldName)) {
                    targetResourceId = reader.getString();
                    targetResourceIdFound = true;
                } else if ("targetResourceRegion".equals(fieldName)) {
                    targetResourceRegion = reader.getString();
                    targetResourceRegionFound = true;
                } else if ("targetModelId".equals(fieldName)) {
                    targetModelId = reader.getString();
                    targetModelIdFound = true;
                } else if ("targetModelLocation".equals(fieldName)) {
                    targetModelLocation = reader.getString();
                    targetModelLocationFound = true;
                } else if ("accessToken".equals(fieldName)) {
                    accessToken = reader.getString();
                    accessTokenFound = true;
                } else if ("expirationDateTime".equals(fieldName)) {
                    expirationDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    expirationDateTimeFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (targetResourceIdFound
                && targetResourceRegionFound
                && targetModelIdFound
                && targetModelLocationFound
                && accessTokenFound
                && expirationDateTimeFound) {
                return new CopyAuthorization(targetResourceId, targetResourceRegion, targetModelId, targetModelLocation,
                    accessToken, expirationDateTime);
            }
            List<String> missingProperties = new ArrayList<>();
            if (!targetResourceIdFound) {
                missingProperties.add("targetResourceId");
            }
            if (!targetResourceRegionFound) {
                missingProperties.add("targetResourceRegion");
            }
            if (!targetModelIdFound) {
                missingProperties.add("targetModelId");
            }
            if (!targetModelLocationFound) {
                missingProperties.add("targetModelLocation");
            }
            if (!accessTokenFound) {
                missingProperties.add("accessToken");
            }
            if (!expirationDateTimeFound) {
                missingProperties.add("expirationDateTime");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
