// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Semantic data type of the field value.
 */
public final class DocumentFieldType extends ExpandableStringEnum<DocumentFieldType> {
    /**
     * Plain text.
     */
    public static final DocumentFieldType STRING = fromString("string");

    /**
     * Date, normalized to ISO 8601 (YYYY-MM-DD) format.
     */
    public static final DocumentFieldType DATE = fromString("date");

    /**
     * Time, normalized to ISO 8601 (hh:mm:ss) format.
     */
    public static final DocumentFieldType TIME = fromString("time");

    /**
     * Phone number, normalized to E.164 (+{CountryCode}{SubscriberNumber}) format.
     */
    public static final DocumentFieldType PHONE_NUMBER = fromString("phoneNumber");

    /**
     * Floating point number, normalized to double precision floating point.
     */
    public static final DocumentFieldType NUMBER = fromString("number");

    /**
     * Integer number, normalized to 64-bit signed integer.
     */
    public static final DocumentFieldType INTEGER = fromString("integer");

    /**
     * Is field selected?.
     */
    public static final DocumentFieldType SELECTION_MARK = fromString("selectionMark");

    /**
     * Country/region, normalized to ISO 3166-1 alpha-3 format (ex. USA).
     */
    public static final DocumentFieldType COUNTRY_REGION = fromString("countryRegion");

    /**
     * Is signature present?.
     */
    public static final DocumentFieldType SIGNATURE = fromString("signature");

    /**
     * List of subfields of the same type.
     */
    public static final DocumentFieldType ARRAY = fromString("array");

    /**
     * Named list of subfields of potentially different types.
     */
    public static final DocumentFieldType OBJECT = fromString("object");

    /**
     * Currency amount with optional currency symbol and unit.
     */
    public static final DocumentFieldType CURRENCY = fromString("currency");

    /**
     * Parsed address.
     */
    public static final DocumentFieldType ADDRESS = fromString("address");

    /**
     * Boolean value, normalized to true or false.
     */
    public static final DocumentFieldType BOOLEAN = fromString("boolean");

    /**
     * Creates a new instance of DocumentFieldType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DocumentFieldType() {
    }

    /**
     * Creates or finds a DocumentFieldType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DocumentFieldType.
     */
    public static DocumentFieldType fromString(String name) {
        return fromString(name, DocumentFieldType.class);
    }

    /**
     * Gets known DocumentFieldType values.
     * 
     * @return known DocumentFieldType values.
     */
    public static Collection<DocumentFieldType> values() {
        return values(DocumentFieldType.class);
    }
}
