// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A selection mark object representing check boxes, radio buttons, and other elements indicating a selection.
 */
@Fluent
public final class DocumentSelectionMark implements JsonSerializable<DocumentSelectionMark> {
    /*
     * State of the selection mark.
     */
    private final SelectionMarkState state;

    /*
     * Bounding polygon of the selection mark.
     */
    private List<Float> polygon;

    /*
     * Location of the selection mark in the reading order concatenated content.
     */
    private final DocumentSpan span;

    /*
     * Confidence of correctly extracting the selection mark.
     */
    private final float confidence;

    /**
     * Creates an instance of DocumentSelectionMark class.
     * 
     * @param state the state value to set.
     * @param span the span value to set.
     * @param confidence the confidence value to set.
     */
    public DocumentSelectionMark(SelectionMarkState state, DocumentSpan span, float confidence) {
        this.state = state;
        this.span = span;
        this.confidence = confidence;
    }

    /**
     * Get the state property: State of the selection mark.
     * 
     * @return the state value.
     */
    public SelectionMarkState getState() {
        return this.state;
    }

    /**
     * Get the polygon property: Bounding polygon of the selection mark.
     * 
     * @return the polygon value.
     */
    public List<Float> getPolygon() {
        return this.polygon;
    }

    /**
     * Set the polygon property: Bounding polygon of the selection mark.
     * 
     * @param polygon the polygon value to set.
     * @return the DocumentSelectionMark object itself.
     */
    public DocumentSelectionMark setPolygon(List<Float> polygon) {
        this.polygon = polygon;
        return this;
    }

    /**
     * Get the span property: Location of the selection mark in the reading order concatenated content.
     * 
     * @return the span value.
     */
    public DocumentSpan getSpan() {
        return this.span;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the selection mark.
     * 
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("span", this.span);
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeFloat(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentSelectionMark from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentSelectionMark if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentSelectionMark.
     */
    public static DocumentSelectionMark fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean stateFound = false;
            SelectionMarkState state = null;
            boolean spanFound = false;
            DocumentSpan span = null;
            boolean confidenceFound = false;
            float confidence = 0.0f;
            List<Float> polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    state = SelectionMarkState.fromString(reader.getString());
                    stateFound = true;
                } else if ("span".equals(fieldName)) {
                    span = DocumentSpan.fromJson(reader);
                    spanFound = true;
                } else if ("confidence".equals(fieldName)) {
                    confidence = reader.getFloat();
                    confidenceFound = true;
                } else if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> reader1.getFloat());
                } else {
                    reader.skipChildren();
                }
            }
            if (stateFound && spanFound && confidenceFound) {
                DocumentSelectionMark deserializedDocumentSelectionMark
                    = new DocumentSelectionMark(state, span, confidence);
                deserializedDocumentSelectionMark.polygon = polygon;

                return deserializedDocumentSelectionMark;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!stateFound) {
                missingProperties.add("state");
            }
            if (!spanFound) {
                missingProperties.add("span");
            }
            if (!confidenceFound) {
                missingProperties.add("confidence");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
