// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A table object consisting table cells arranged in a rectangular layout.
 */
@Fluent
public final class DocumentTable implements JsonSerializable<DocumentTable> {
    /*
     * Number of rows in the table.
     */
    private final int rowCount;

    /*
     * Number of columns in the table.
     */
    private final int columnCount;

    /*
     * Cells contained within the table.
     */
    private final List<DocumentTableCell> cells;

    /*
     * Bounding regions covering the table.
     */
    private List<BoundingRegion> boundingRegions;

    /*
     * Location of the table in the reading order concatenated content.
     */
    private final List<DocumentSpan> spans;

    /**
     * Creates an instance of DocumentTable class.
     * 
     * @param rowCount the rowCount value to set.
     * @param columnCount the columnCount value to set.
     * @param cells the cells value to set.
     * @param spans the spans value to set.
     */
    public DocumentTable(int rowCount, int columnCount, List<DocumentTableCell> cells, List<DocumentSpan> spans) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cells = cells;
        this.spans = spans;
    }

    /**
     * Get the rowCount property: Number of rows in the table.
     * 
     * @return the rowCount value.
     */
    public int getRowCount() {
        return this.rowCount;
    }

    /**
     * Get the columnCount property: Number of columns in the table.
     * 
     * @return the columnCount value.
     */
    public int getColumnCount() {
        return this.columnCount;
    }

    /**
     * Get the cells property: Cells contained within the table.
     * 
     * @return the cells value.
     */
    public List<DocumentTableCell> getCells() {
        return this.cells;
    }

    /**
     * Get the boundingRegions property: Bounding regions covering the table.
     * 
     * @return the boundingRegions value.
     */
    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    /**
     * Set the boundingRegions property: Bounding regions covering the table.
     * 
     * @param boundingRegions the boundingRegions value to set.
     * @return the DocumentTable object itself.
     */
    public DocumentTable setBoundingRegions(List<BoundingRegion> boundingRegions) {
        this.boundingRegions = boundingRegions;
        return this;
    }

    /**
     * Get the spans property: Location of the table in the reading order concatenated content.
     * 
     * @return the spans value.
     */
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("rowCount", this.rowCount);
        jsonWriter.writeIntField("columnCount", this.columnCount);
        jsonWriter.writeArrayField("cells", this.cells, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentTable from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentTable if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentTable.
     */
    public static DocumentTable fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean rowCountFound = false;
            int rowCount = 0;
            boolean columnCountFound = false;
            int columnCount = 0;
            boolean cellsFound = false;
            List<DocumentTableCell> cells = null;
            boolean spansFound = false;
            List<DocumentSpan> spans = null;
            List<BoundingRegion> boundingRegions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("rowCount".equals(fieldName)) {
                    rowCount = reader.getInt();
                    rowCountFound = true;
                } else if ("columnCount".equals(fieldName)) {
                    columnCount = reader.getInt();
                    columnCountFound = true;
                } else if ("cells".equals(fieldName)) {
                    cells = reader.readArray(reader1 -> DocumentTableCell.fromJson(reader1));
                    cellsFound = true;
                } else if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                } else if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            if (rowCountFound && columnCountFound && cellsFound && spansFound) {
                DocumentTable deserializedDocumentTable = new DocumentTable(rowCount, columnCount, cells, spans);
                deserializedDocumentTable.boundingRegions = boundingRegions;

                return deserializedDocumentTable;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!rowCountFound) {
                missingProperties.add("rowCount");
            }
            if (!columnCountFound) {
                missingProperties.add("columnCount");
            }
            if (!cellsFound) {
                missingProperties.add("cells");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
