// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeBusinessCardHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeIdDocumentHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeInvoiceHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeLayoutHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzersAnalyzeReceiptHeaders;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.implementation.models.Language;
import com.azure.ai.formrecognizer.implementation.models.Locale;
import com.azure.ai.formrecognizer.implementation.models.ReadingOrder;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in Analyzers.
 */
public final class AnalyzersImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final AnalyzersService service;

    /**
     * The service client containing this operation class.
     */
    private final FormRecognizerClientImpl client;

    /**
     * Initializes an instance of AnalyzersImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    AnalyzersImpl(FormRecognizerClientImpl client) {
        this.service
            = RestProxy.create(AnalyzersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for FormRecognizerClientAnalyzers to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}/formrecognizer/{ApiVersion}")
    @ServiceInterface(name = "FormRecognizerClient")
    public interface AnalyzersService {
        @Post("/prebuilt/businessCard/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCard(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @QueryParam("includeTextDetails") Boolean includeTextDetails, @QueryParam("locale") Locale locale,
            @QueryParam("pages") String pages, @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/businessCard/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeBusinessCardNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/businessCard/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCard(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @QueryParam("includeTextDetails") Boolean includeTextDetails, @QueryParam("locale") Locale locale,
            @QueryParam("pages") String pages, @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/businessCard/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeBusinessCardNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/businessCard/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCard(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @QueryParam("includeTextDetails") Boolean includeTextDetails, @QueryParam("locale") Locale locale,
            @QueryParam("pages") String pages, @BodyParam("application/json") SourcePath fileStream,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/businessCard/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeBusinessCardNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @BodyParam("application/json") SourcePath fileStream, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/prebuilt/businessCard/analyzeResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResult(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("resultId") UUID resultId,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/invoice/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoice(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/invoice/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeInvoiceNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/invoice/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoice(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/invoice/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeInvoiceNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/invoice/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoice(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @BodyParam("application/json") SourcePath fileStream, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/prebuilt/invoice/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeInvoiceNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @BodyParam("application/json") SourcePath fileStream, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/prebuilt/invoice/analyzeResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResult(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("resultId") UUID resultId,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/idDocument/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocument(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @QueryParam("includeTextDetails") Boolean includeTextDetails, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/idDocument/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeIdDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("pages") String pages, @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/idDocument/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocument(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @QueryParam("includeTextDetails") Boolean includeTextDetails, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/idDocument/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeIdDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("pages") String pages, @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/idDocument/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocument(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @QueryParam("includeTextDetails") Boolean includeTextDetails, @QueryParam("pages") String pages,
            @BodyParam("application/json") SourcePath fileStream, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/prebuilt/idDocument/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeIdDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("pages") String pages, @BodyParam("application/json") SourcePath fileStream,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/prebuilt/idDocument/analyzeResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResult(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("resultId") UUID resultId,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/receipt/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceipt(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/receipt/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeReceiptNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/receipt/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceipt(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/receipt/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeReceiptNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/prebuilt/receipt/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceipt(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @BodyParam("application/json") SourcePath fileStream, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/prebuilt/receipt/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeReceiptNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("locale") Locale locale, @QueryParam("pages") String pages,
            @BodyParam("application/json") SourcePath fileStream, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/prebuilt/receipt/analyzeResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResult(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("resultId") UUID resultId,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/layout/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayout(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("pages") String pages,
            @QueryParam("language") Language language, @QueryParam("readingOrder") ReadingOrder readingOrder,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/layout/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeLayoutNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("pages") String pages,
            @QueryParam("language") Language language, @QueryParam("readingOrder") ReadingOrder readingOrder,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/layout/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayout(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("pages") String pages,
            @QueryParam("language") Language language, @QueryParam("readingOrder") ReadingOrder readingOrder,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/layout/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeLayoutNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("pages") String pages,
            @QueryParam("language") Language language, @QueryParam("readingOrder") ReadingOrder readingOrder,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/layout/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayout(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("pages") String pages,
            @QueryParam("language") Language language, @QueryParam("readingOrder") ReadingOrder readingOrder,
            @BodyParam("application/json") SourcePath fileStream, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/layout/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeLayoutNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("pages") String pages,
            @QueryParam("language") Language language, @QueryParam("readingOrder") ReadingOrder readingOrder,
            @BodyParam("application/json") SourcePath fileStream, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/layout/analyzeResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResult(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("resultId") UUID resultId,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails,
            locale, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeBusinessCard(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void> analyzeBusinessCardWithResponse(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeBusinessCard(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        analyzeBusinessCardWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength,
            Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeBusinessCardNoCustomHeadersWithResponseAsync(contentType,
            includeTextDetails, locale, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeBusinessCardNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeBusinessCardNoCustomHeadersWithResponse(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        return analyzeBusinessCardNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages,
            fileStream, contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails,
            locale, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream,
        Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeBusinessCard(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, BinaryData fileStream, Long contentLength) {
        return analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void> analyzeBusinessCardWithResponse(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream,
        Long contentLength, Context context) {
        return analyzeBusinessCardWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeBusinessCard(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, BinaryData fileStream, Long contentLength) {
        analyzeBusinessCardWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength,
            Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeBusinessCardNoCustomHeadersWithResponseAsync(contentType,
            includeTextDetails, locale, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength,
        Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeBusinessCardNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeBusinessCardNoCustomHeadersWithResponse(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength,
        Context context) {
        return analyzeBusinessCardNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages,
            fileStream, contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(
        Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(
            context -> analyzeBusinessCardWithResponseAsync(includeTextDetails, locale, pages, fileStream, context));
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void>> analyzeBusinessCardWithResponseAsync(
        Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeBusinessCard(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            locale, pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(Boolean includeTextDetails, Locale locale, List<String> pages,
        SourcePath fileStream) {
        return analyzeBusinessCardWithResponseAsync(includeTextDetails, locale, pages, fileStream)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeBusinessCardAsync(Boolean includeTextDetails, Locale locale, List<String> pages,
        SourcePath fileStream, Context context) {
        return analyzeBusinessCardWithResponseAsync(includeTextDetails, locale, pages, fileStream, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeBusinessCardHeaders, Void> analyzeBusinessCardWithResponse(
        Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeBusinessCardWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeBusinessCard(Boolean includeTextDetails, Locale locale, List<String> pages,
        SourcePath fileStream) {
        analyzeBusinessCardWithResponse(includeTextDetails, locale, pages, fileStream, Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(Boolean includeTextDetails,
        Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> analyzeBusinessCardNoCustomHeadersWithResponseAsync(includeTextDetails,
            locale, pages, fileStream, context));
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeBusinessCardNoCustomHeadersWithResponseAsync(Boolean includeTextDetails,
        Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeBusinessCardNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, locale, pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract field text and semantic values from a given business card document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeBusinessCardNoCustomHeadersWithResponse(Boolean includeTextDetails, Locale locale,
        List<String> pages, SourcePath fileStream, Context context) {
        return analyzeBusinessCardNoCustomHeadersWithResponseAsync(includeTextDetails, locale, pages, fileStream,
            context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> getAnalyzeBusinessCardResultWithResponseAsync(resultId, context));
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeBusinessCardResultWithResponseAsync(UUID resultId,
        Context context) {
        final String accept = "application/json";
        return service.getAnalyzeBusinessCardResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId,
            accept, context);
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeBusinessCardResultAsync(UUID resultId) {
        return getAnalyzeBusinessCardResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeBusinessCardResultAsync(UUID resultId, Context context) {
        return getAnalyzeBusinessCardResultWithResponseAsync(resultId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeBusinessCardResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeBusinessCardResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze business card operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeBusinessCardResult(UUID resultId) {
        return getAnalyzeBusinessCardResultWithResponse(resultId, Context.NONE).getValue();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale,
            pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeInvoice(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void> analyzeInvoiceWithResponse(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        return analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeInvoice(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        analyzeInvoiceWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength,
            Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeInvoiceNoCustomHeadersWithResponseAsync(contentType,
            includeTextDetails, locale, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeInvoiceNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeInvoiceNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails,
        Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return analyzeInvoiceNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages,
            fileStream, contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale,
            pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream,
        Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeInvoice(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, BinaryData fileStream, Long contentLength) {
        return analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void> analyzeInvoiceWithResponse(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength,
        Context context) {
        return analyzeInvoiceWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeInvoice(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        BinaryData fileStream, Long contentLength) {
        analyzeInvoiceWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength,
            Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeInvoiceNoCustomHeadersWithResponseAsync(contentType,
            includeTextDetails, locale, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength,
        Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeInvoiceNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeInvoiceNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails,
        Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeInvoiceNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages,
            fileStream, contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(
        Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(
            context -> analyzeInvoiceWithResponseAsync(includeTextDetails, locale, pages, fileStream, context));
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void>> analyzeInvoiceWithResponseAsync(
        Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeInvoice(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            locale, pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(Boolean includeTextDetails, Locale locale, List<String> pages,
        SourcePath fileStream) {
        return analyzeInvoiceWithResponseAsync(includeTextDetails, locale, pages, fileStream)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeInvoiceAsync(Boolean includeTextDetails, Locale locale, List<String> pages,
        SourcePath fileStream, Context context) {
        return analyzeInvoiceWithResponseAsync(includeTextDetails, locale, pages, fileStream, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeInvoiceHeaders, Void> analyzeInvoiceWithResponse(Boolean includeTextDetails,
        Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeInvoiceWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeInvoice(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        analyzeInvoiceWithResponse(includeTextDetails, locale, pages, fileStream, Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(Boolean includeTextDetails,
        Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> analyzeInvoiceNoCustomHeadersWithResponseAsync(includeTextDetails,
            locale, pages, fileStream, context));
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeInvoiceNoCustomHeadersWithResponseAsync(Boolean includeTextDetails,
        Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeInvoiceNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, locale, pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract field text and semantic values from a given invoice document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeInvoiceNoCustomHeadersWithResponse(Boolean includeTextDetails, Locale locale,
        List<String> pages, SourcePath fileStream, Context context) {
        return analyzeInvoiceNoCustomHeadersWithResponseAsync(includeTextDetails, locale, pages, fileStream, context)
            .block();
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> getAnalyzeInvoiceResultWithResponseAsync(resultId, context));
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeInvoiceResultWithResponseAsync(UUID resultId,
        Context context) {
        final String accept = "application/json";
        return service.getAnalyzeInvoiceResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId, accept,
            context);
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeInvoiceResultAsync(UUID resultId) {
        return getAnalyzeInvoiceResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeInvoiceResultAsync(UUID resultId, Context context) {
        return getAnalyzeInvoiceResultWithResponseAsync(resultId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeInvoiceResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeInvoiceResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze invoice operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeInvoiceResult(UUID resultId) {
        return getAnalyzeInvoiceResultWithResponse(resultId, Context.NONE).getValue();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails,
            pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream,
        Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeIdDocument(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        return analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength,
            context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void> analyzeIdDocumentWithResponse(ContentType contentType,
        Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        return analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength,
            context).block();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeIdDocument(ContentType contentType, Boolean includeTextDetails, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        analyzeIdDocumentWithResponse(contentType, includeTextDetails, pages, fileStream, contentLength, Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeIdDocumentNoCustomHeadersWithResponseAsync(contentType,
            includeTextDetails, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeIdDocumentNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeIdDocumentNoCustomHeadersWithResponse(ContentType contentType,
        Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        return analyzeIdDocumentNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails,
            pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream,
        Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeIdDocument(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages,
        BinaryData fileStream, Long contentLength) {
        return analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(ContentType contentType, Boolean includeTextDetails, List<String> pages,
        BinaryData fileStream, Long contentLength, Context context) {
        return analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength,
            context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void> analyzeIdDocumentWithResponse(ContentType contentType,
        Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeIdDocumentWithResponseAsync(contentType, includeTextDetails, pages, fileStream, contentLength,
            context).block();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeIdDocument(ContentType contentType, Boolean includeTextDetails, List<String> pages,
        BinaryData fileStream, Long contentLength) {
        analyzeIdDocumentWithResponse(contentType, includeTextDetails, pages, fileStream, contentLength, Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeIdDocumentNoCustomHeadersWithResponseAsync(contentType,
            includeTextDetails, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeIdDocumentNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeIdDocumentNoCustomHeadersWithResponse(ContentType contentType,
        Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeIdDocumentNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>>
        analyzeIdDocumentWithResponseAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return FluxUtil
            .withContext(context -> analyzeIdDocumentWithResponseAsync(includeTextDetails, pages, fileStream, context));
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void>> analyzeIdDocumentWithResponseAsync(
        Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeIdDocument(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return analyzeIdDocumentWithResponseAsync(includeTextDetails, pages, fileStream)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeIdDocumentAsync(Boolean includeTextDetails, List<String> pages, SourcePath fileStream,
        Context context) {
        return analyzeIdDocumentWithResponseAsync(includeTextDetails, pages, fileStream, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeIdDocumentHeaders, Void> analyzeIdDocumentWithResponse(
        Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeIdDocumentWithResponseAsync(includeTextDetails, pages, fileStream, context).block();
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeIdDocument(Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        analyzeIdDocumentWithResponse(includeTextDetails, pages, fileStream, Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(Boolean includeTextDetails,
        List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> analyzeIdDocumentNoCustomHeadersWithResponseAsync(includeTextDetails,
            pages, fileStream, context));
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeIdDocumentNoCustomHeadersWithResponseAsync(Boolean includeTextDetails,
        List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeIdDocumentNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract field text and semantic values from a given ID document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeIdDocumentNoCustomHeadersWithResponse(Boolean includeTextDetails, List<String> pages,
        SourcePath fileStream, Context context) {
        return analyzeIdDocumentNoCustomHeadersWithResponseAsync(includeTextDetails, pages, fileStream, context)
            .block();
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> getAnalyzeIdDocumentResultWithResponseAsync(resultId, context));
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeIdDocumentResultWithResponseAsync(UUID resultId,
        Context context) {
        final String accept = "application/json";
        return service.getAnalyzeIdDocumentResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId,
            accept, context);
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeIdDocumentResultAsync(UUID resultId) {
        return getAnalyzeIdDocumentResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeIdDocumentResultAsync(UUID resultId, Context context) {
        return getAnalyzeIdDocumentResultWithResponseAsync(resultId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeIdDocumentResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeIdDocumentResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze ID operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeIdDocumentResult(UUID resultId) {
        return getAnalyzeIdDocumentResultWithResponse(resultId, Context.NONE).getValue();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale,
            pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeReceipt(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void> analyzeReceiptWithResponse(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        return analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeReceipt(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        analyzeReceiptWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength,
            Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeReceiptNoCustomHeadersWithResponseAsync(contentType,
            includeTextDetails, locale, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeReceiptNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeReceiptNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails,
        Locale locale, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return analyzeReceiptNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages,
            fileStream, contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale,
            pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(
        ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream,
        Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeReceipt(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, BinaryData fileStream, Long contentLength) {
        return analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(ContentType contentType, Boolean includeTextDetails, Locale locale,
        List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void> analyzeReceiptWithResponse(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength,
        Context context) {
        return analyzeReceiptWithResponseAsync(contentType, includeTextDetails, locale, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeReceipt(ContentType contentType, Boolean includeTextDetails, Locale locale, List<String> pages,
        BinaryData fileStream, Long contentLength) {
        analyzeReceiptWithResponse(contentType, includeTextDetails, locale, pages, fileStream, contentLength,
            Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeReceiptNoCustomHeadersWithResponseAsync(contentType,
            includeTextDetails, locale, pages, fileStream, contentLength, context));
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(ContentType contentType,
        Boolean includeTextDetails, Locale locale, List<String> pages, BinaryData fileStream, Long contentLength,
        Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeReceiptNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, locale, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeReceiptNoCustomHeadersWithResponse(ContentType contentType, Boolean includeTextDetails,
        Locale locale, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeReceiptNoCustomHeadersWithResponseAsync(contentType, includeTextDetails, locale, pages,
            fileStream, contentLength, context).block();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(
        Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(
            context -> analyzeReceiptWithResponseAsync(includeTextDetails, locale, pages, fileStream, context));
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void>> analyzeReceiptWithResponseAsync(
        Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeReceipt(this.client.getEndpoint(), this.client.getApiVersion(), includeTextDetails,
            locale, pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(Boolean includeTextDetails, Locale locale, List<String> pages,
        SourcePath fileStream) {
        return analyzeReceiptWithResponseAsync(includeTextDetails, locale, pages, fileStream)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeReceiptAsync(Boolean includeTextDetails, Locale locale, List<String> pages,
        SourcePath fileStream, Context context) {
        return analyzeReceiptWithResponseAsync(includeTextDetails, locale, pages, fileStream, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeReceiptHeaders, Void> analyzeReceiptWithResponse(Boolean includeTextDetails,
        Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeReceiptWithResponseAsync(includeTextDetails, locale, pages, fileStream, context).block();
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeReceipt(Boolean includeTextDetails, Locale locale, List<String> pages, SourcePath fileStream) {
        analyzeReceiptWithResponse(includeTextDetails, locale, pages, fileStream, Context.NONE);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(Boolean includeTextDetails,
        Locale locale, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> analyzeReceiptNoCustomHeadersWithResponseAsync(includeTextDetails,
            locale, pages, fileStream, context));
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeReceiptNoCustomHeadersWithResponseAsync(Boolean includeTextDetails,
        Locale locale, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeReceiptNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            includeTextDetails, locale, pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract field text and semantic values from a given receipt document. The input document must be of one of the
     * supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri) of the document to be analyzed.
     * 
     * @param includeTextDetails Include text lines and element references in the result.
     * @param locale Locale of the input document. Supported locales include: en-AU, en-CA, en-GB, en-IN,
     * en-US(default).
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeReceiptNoCustomHeadersWithResponse(Boolean includeTextDetails, Locale locale,
        List<String> pages, SourcePath fileStream, Context context) {
        return analyzeReceiptNoCustomHeadersWithResponseAsync(includeTextDetails, locale, pages, fileStream, context)
            .block();
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> getAnalyzeReceiptResultWithResponseAsync(resultId, context));
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(UUID resultId,
        Context context) {
        final String accept = "application/json";
        return service.getAnalyzeReceiptResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId, accept,
            context);
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeReceiptResultAsync(UUID resultId) {
        return getAnalyzeReceiptResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeReceiptResultAsync(UUID resultId, Context context) {
        return getAnalyzeReceiptResultWithResponseAsync(resultId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeReceiptResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeReceiptResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze receipt operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeReceiptResult(UUID resultId) {
        return getAnalyzeReceiptResultWithResponse(resultId, Context.NONE).getValue();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(
        ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeLayoutWithResponseAsync(contentType, pages, language,
            readingOrder, fileStream, contentLength, context));
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(
        ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder,
        Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeLayout(this.client.getEndpoint(), this.client.getApiVersion(), pagesConverted, language,
            readingOrder, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(ContentType contentType, List<String> pages, Language language,
        ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength) {
        return analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(ContentType contentType, List<String> pages, Language language,
        ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength,
            context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void> analyzeLayoutWithResponse(ContentType contentType,
        List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream,
        Long contentLength, Context context) {
        return analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength,
            context).block();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeLayout(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        analyzeLayoutWithResponse(contentType, pages, language, readingOrder, fileStream, contentLength, Context.NONE);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(ContentType contentType,
        List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeLayoutNoCustomHeadersWithResponseAsync(contentType, pages,
            language, readingOrder, fileStream, contentLength, context));
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(ContentType contentType,
        List<String> pages, Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream,
        Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeLayoutNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            pagesConverted, language, readingOrder, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeLayoutNoCustomHeadersWithResponse(ContentType contentType, List<String> pages,
        Language language, ReadingOrder readingOrder, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        return analyzeLayoutNoCustomHeadersWithResponseAsync(contentType, pages, language, readingOrder, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(
        ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder,
        BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeLayoutWithResponseAsync(contentType, pages, language,
            readingOrder, fileStream, contentLength, context));
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(
        ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder,
        BinaryData fileStream, Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeLayout(this.client.getEndpoint(), this.client.getApiVersion(), pagesConverted, language,
            readingOrder, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(ContentType contentType, List<String> pages, Language language,
        ReadingOrder readingOrder, BinaryData fileStream, Long contentLength) {
        return analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(ContentType contentType, List<String> pages, Language language,
        ReadingOrder readingOrder, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength,
            context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void> analyzeLayoutWithResponse(ContentType contentType,
        List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength,
        Context context) {
        return analyzeLayoutWithResponseAsync(contentType, pages, language, readingOrder, fileStream, contentLength,
            context).block();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeLayout(ContentType contentType, List<String> pages, Language language, ReadingOrder readingOrder,
        BinaryData fileStream, Long contentLength) {
        analyzeLayoutWithResponse(contentType, pages, language, readingOrder, fileStream, contentLength, Context.NONE);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(ContentType contentType,
        List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeLayoutNoCustomHeadersWithResponseAsync(contentType, pages,
            language, readingOrder, fileStream, contentLength, context));
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(ContentType contentType,
        List<String> pages, Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength,
        Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeLayoutNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            pagesConverted, language, readingOrder, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param contentType Upload file type.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeLayoutNoCustomHeadersWithResponse(ContentType contentType, List<String> pages,
        Language language, ReadingOrder readingOrder, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeLayoutNoCustomHeadersWithResponseAsync(contentType, pages, language, readingOrder, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(List<String> pages,
        Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        return FluxUtil
            .withContext(context -> analyzeLayoutWithResponseAsync(pages, language, readingOrder, fileStream, context));
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void>> analyzeLayoutWithResponseAsync(List<String> pages,
        Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeLayout(this.client.getEndpoint(), this.client.getApiVersion(), pagesConverted, language,
            readingOrder, fileStream, accept, context);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(List<String> pages, Language language, ReadingOrder readingOrder,
        SourcePath fileStream) {
        return analyzeLayoutWithResponseAsync(pages, language, readingOrder, fileStream)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeLayoutAsync(List<String> pages, Language language, ReadingOrder readingOrder,
        SourcePath fileStream, Context context) {
        return analyzeLayoutWithResponseAsync(pages, language, readingOrder, fileStream, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzersAnalyzeLayoutHeaders, Void> analyzeLayoutWithResponse(List<String> pages,
        Language language, ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        return analyzeLayoutWithResponseAsync(pages, language, readingOrder, fileStream, context).block();
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeLayout(List<String> pages, Language language, ReadingOrder readingOrder, SourcePath fileStream) {
        analyzeLayoutWithResponse(pages, language, readingOrder, fileStream, Context.NONE);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(List<String> pages, Language language,
        ReadingOrder readingOrder, SourcePath fileStream) {
        return FluxUtil.withContext(context -> analyzeLayoutNoCustomHeadersWithResponseAsync(pages, language,
            readingOrder, fileStream, context));
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeLayoutNoCustomHeadersWithResponseAsync(List<String> pages, Language language,
        ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeLayoutNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(),
            pagesConverted, language, readingOrder, fileStream, accept, context);
    }

    /**
     * Extract text and layout information from a given document. The input document must be of one of the supported
     * content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'. Alternatively, use
     * 'application/json' type to specify the location (Uri or local path) of the document to be analyzed.
     * 
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param language Currently, only Afrikaans (‘af’), Albanian (‘sq’), Asturian (‘ast’), Basque (‘eu’), Bislama
     * (‘bi’), Breton (‘br’), Catalan (‘ca’), Cebuano (‘ceb’), Chamorro (‘ch’), Cornish (‘kw’), Corsican (‘co’), Crimean
     * Tatar - Latin script(‘crh’), Czech (‘cs’), Danish (‘da’), Dutch (‘nl’), English ('en'), Estonian (‘et’), Fijian
     * (‘fj’), Filipino (‘fil’), Finnish (‘fi’), French (‘fr’), Friulian (‘fur’), Galician (‘gl’), German (‘de’),
     * Gilbertese (‘gil’), Greenlandic (‘kl’), Haitian Creole (‘ht’), Hani (‘hni’), Hmong Daw (‘mww’), Hungarian (‘hu’),
     * Indonesian (‘id’), Interlingua (‘ia’), Inuktitut (‘iu’), Irish (‘ga’), Italian (‘it’), Japanese (‘ja’), Javanese
     * (‘jv’), Kabuverdianu (‘kea’), Kachin (‘kac’), Kara-Kalpak (‘kaa’), Kashubian (‘csb’), Khasi (‘kha’), Korean
     * (‘ko’), Kurdish - Latin script (‘ku’), K’iche’ (‘quc’), Luxembourgish (‘lb’), Malay (‘ms’), Manx (‘gv’),
     * Neapolitan (‘nap’), Norwegian (‘no’), Occitan (‘oc’), Polish (‘pl’), Portuguese (‘pt’), Romansh (‘rm’), Scots
     * (‘sco’), Scottish Gaelic (‘gd’), simplified Chinese (‘zh-Hans’), Slovenian (‘sl’), Spanish (‘es’), Swahili
     * (‘sw’), Swedish (‘sv’), Tatar - Latin script (‘tt’), Tetum (‘tet’), traditional Chinese (‘zh-Hant’), Turkish
     * (‘tr’), Upper Sorbian (‘hsb’), Uzbek (‘uz’), Volapük (‘vo’), Walser (‘wae’), Western Frisian (‘fy’), Yucatec Maya
     * (‘yua’), Zhuang (‘za’) and Zulu (‘zu’) are supported (print – seventy-three languages and handwritten – English
     * only). Layout supports auto language identification and multi language documents, so only provide a language code
     * if you would like to force the documented to be processed as that specific language.
     * @param readingOrder Reading order algorithm to sort the text lines returned. Supported reading orders include:
     * basic(default), natural.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeLayoutNoCustomHeadersWithResponse(List<String> pages, Language language,
        ReadingOrder readingOrder, SourcePath fileStream, Context context) {
        return analyzeLayoutNoCustomHeadersWithResponseAsync(pages, language, readingOrder, fileStream, context)
            .block();
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> getAnalyzeLayoutResultWithResponseAsync(resultId, context));
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(UUID resultId,
        Context context) {
        final String accept = "application/json";
        return service.getAnalyzeLayoutResult(this.client.getEndpoint(), this.client.getApiVersion(), resultId, accept,
            context);
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeLayoutResultAsync(UUID resultId) {
        return getAnalyzeLayoutResultWithResponseAsync(resultId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeLayoutResultAsync(UUID resultId, Context context) {
        return getAnalyzeLayoutResultWithResponseAsync(resultId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeLayoutResultWithResponse(UUID resultId, Context context) {
        return getAnalyzeLayoutResultWithResponseAsync(resultId, context).block();
    }

    /**
     * Track the progress and obtain the result of the analyze layout operation.
     * 
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeLayoutResult(UUID resultId) {
        return getAnalyzeLayoutResultWithResponse(resultId, Context.NONE).getValue();
    }
}
