// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.ComposeRequest;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.CopyAuthorizationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyOperationResult;
import com.azure.ai.formrecognizer.implementation.models.CopyRequest;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsAnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsAuthorizeModelCopyHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsComposeHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsCopyHeaders;
import com.azure.ai.formrecognizer.implementation.models.CustomModelsTrainHeaders;
import com.azure.ai.formrecognizer.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.Models;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.ai.formrecognizer.implementation.models.TrainRequest;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in CustomModels.
 */
public final class CustomModelsImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final CustomModelsService service;

    /**
     * The service client containing this operation class.
     */
    private final FormRecognizerClientImpl client;

    /**
     * Initializes an instance of CustomModelsImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    CustomModelsImpl(FormRecognizerClientImpl client) {
        this.service
            = RestProxy.create(CustomModelsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for FormRecognizerClientCustomModels to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{endpoint}/formrecognizer/{ApiVersion}")
    @ServiceInterface(name = "FormRecognizerClient")
    public interface CustomModelsService {
        @Post("/custom/models")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<CustomModelsTrainHeaders, Void>> train(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @BodyParam("application/json") TrainRequest trainRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> trainNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @BodyParam("application/json") TrainRequest trainRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/custom/models/{modelId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Model>> get(@HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @PathParam("modelId") UUID modelId, @QueryParam("includeKeys") Boolean includeKeys,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/custom/models/{modelId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> delete(@HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @PathParam("modelId") UUID modelId, @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/{modelId}/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @PathParam("modelId") UUID modelId, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("pages") String pages, @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/{modelId}/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("modelId") UUID modelId,
            @QueryParam("includeTextDetails") Boolean includeTextDetails, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/{modelId}/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @PathParam("modelId") UUID modelId, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("pages") String pages, @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/{modelId}/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("modelId") UUID modelId,
            @QueryParam("includeTextDetails") Boolean includeTextDetails, @QueryParam("pages") String pages,
            @HeaderParam("Content-Type") ContentType contentType,
            @BodyParam("application/octet-stream") BinaryData fileStream,
            @HeaderParam("Content-Length") Long contentLength, @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/{modelId}/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocument(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @PathParam("modelId") UUID modelId, @QueryParam("includeTextDetails") Boolean includeTextDetails,
            @QueryParam("pages") String pages, @BodyParam("application/json") SourcePath fileStream,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/{modelId}/analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> analyzeDocumentNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("modelId") UUID modelId,
            @QueryParam("includeTextDetails") Boolean includeTextDetails, @QueryParam("pages") String pages,
            @BodyParam("application/json") SourcePath fileStream, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/custom/models/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeOperationResult>> getAnalyzeResult(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("modelId") UUID modelId,
            @PathParam("resultId") UUID resultId, @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/{modelId}/copy")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<CustomModelsCopyHeaders, Void>> copy(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("modelId") UUID modelId,
            @BodyParam("application/json") CopyRequest copyRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/custom/models/{modelId}/copy")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> copyNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("modelId") UUID modelId,
            @BodyParam("application/json") CopyRequest copyRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Get("/custom/models/{modelId}/copyResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<CopyOperationResult>> getCopyResult(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @PathParam("modelId") UUID modelId,
            @PathParam("resultId") UUID resultId, @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/copyAuthorization")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<CustomModelsAuthorizeModelCopyHeaders, CopyAuthorizationResult>> authorizeModelCopy(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/copyAuthorization")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<CopyAuthorizationResult>> authorizeModelCopyNoCustomHeaders(
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/compose")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<CustomModelsComposeHeaders, Void>> compose(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @BodyParam("application/json") ComposeRequest composeRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/custom/models/compose")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> composeNoCustomHeaders(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @BodyParam("application/json") ComposeRequest composeRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/custom/models")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Models>> list(@HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @QueryParam("op") String op, @HeaderParam("Accept") String accept, Context context);

        @Get("/custom/models")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Models>> getSummary(@HostParam("endpoint") String endpoint,
            @HostParam("ApiVersion") String apiVersion, @QueryParam("op") String op,
            @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Models>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("endpoint") String endpoint, @HostParam("ApiVersion") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     * 
     * @param trainRequest Training request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsTrainHeaders, Void>> trainWithResponseAsync(TrainRequest trainRequest) {
        return FluxUtil.withContext(context -> trainWithResponseAsync(trainRequest, context));
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     * 
     * @param trainRequest Training request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsTrainHeaders, Void>> trainWithResponseAsync(TrainRequest trainRequest,
        Context context) {
        final String accept = "application/json";
        return service.train(this.client.getEndpoint(), this.client.getApiVersion(), trainRequest, accept, context);
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     * 
     * @param trainRequest Training request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> trainAsync(TrainRequest trainRequest) {
        return trainWithResponseAsync(trainRequest).flatMap(ignored -> Mono.empty());
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     * 
     * @param trainRequest Training request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> trainAsync(TrainRequest trainRequest, Context context) {
        return trainWithResponseAsync(trainRequest, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     * 
     * @param trainRequest Training request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CustomModelsTrainHeaders, Void> trainWithResponse(TrainRequest trainRequest, Context context) {
        return trainWithResponseAsync(trainRequest, context).block();
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     * 
     * @param trainRequest Training request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void train(TrainRequest trainRequest) {
        trainWithResponse(trainRequest, Context.NONE);
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     * 
     * @param trainRequest Training request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> trainNoCustomHeadersWithResponseAsync(TrainRequest trainRequest) {
        return FluxUtil.withContext(context -> trainNoCustomHeadersWithResponseAsync(trainRequest, context));
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     * 
     * @param trainRequest Training request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> trainNoCustomHeadersWithResponseAsync(TrainRequest trainRequest, Context context) {
        final String accept = "application/json";
        return service.trainNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), trainRequest,
            accept, context);
    }

    /**
     * Create and train a custom model. The request must include a source parameter that is either an externally
     * accessible Azure storage blob container Uri (preferably a Shared Access Signature Uri) or valid path to a data
     * folder in a locally mounted drive. When local paths are specified, they must follow the Linux/Unix path format
     * and be an absolute path rooted to the input mount configuration setting value e.g., if '{Mounts:Input}'
     * configuration setting value is '/input' then a valid source path would be '/input/contosodataset'. All data to be
     * trained is expected to be under the source folder or sub folders under it. Models are trained using documents
     * that are of the following content type - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or
     * 'image/bmp'. Other type of content is ignored.
     * 
     * @param trainRequest Training request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> trainNoCustomHeadersWithResponse(TrainRequest trainRequest, Context context) {
        return trainNoCustomHeadersWithResponseAsync(trainRequest, context).block();
    }

    /**
     * Get detailed information about a custom model.
     * 
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Model>> getWithResponseAsync(UUID modelId, Boolean includeKeys) {
        return FluxUtil.withContext(context -> getWithResponseAsync(modelId, includeKeys, context));
    }

    /**
     * Get detailed information about a custom model.
     * 
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Model>> getWithResponseAsync(UUID modelId, Boolean includeKeys, Context context) {
        final String accept = "application/json";
        return service.get(this.client.getEndpoint(), this.client.getApiVersion(), modelId, includeKeys, accept,
            context);
    }

    /**
     * Get detailed information about a custom model.
     * 
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Model> getAsync(UUID modelId, Boolean includeKeys) {
        return getWithResponseAsync(modelId, includeKeys).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get detailed information about a custom model.
     * 
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Model> getAsync(UUID modelId, Boolean includeKeys, Context context) {
        return getWithResponseAsync(modelId, includeKeys, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get detailed information about a custom model.
     * 
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Model> getWithResponse(UUID modelId, Boolean includeKeys, Context context) {
        return getWithResponseAsync(modelId, includeKeys, context).block();
    }

    /**
     * Get detailed information about a custom model.
     * 
     * @param modelId Model identifier.
     * @param includeKeys Include list of extracted keys in model information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a custom model.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Model get(UUID modelId, Boolean includeKeys) {
        return getWithResponse(modelId, includeKeys, Context.NONE).getValue();
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     * 
     * @param modelId Model identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(UUID modelId) {
        return FluxUtil.withContext(context -> deleteWithResponseAsync(modelId, context));
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     * 
     * @param modelId Model identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(UUID modelId, Context context) {
        final String accept = "application/json";
        return service.delete(this.client.getEndpoint(), this.client.getApiVersion(), modelId, accept, context);
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     * 
     * @param modelId Model identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(UUID modelId) {
        return deleteWithResponseAsync(modelId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     * 
     * @param modelId Model identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(UUID modelId, Context context) {
        return deleteWithResponseAsync(modelId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     * 
     * @param modelId Model identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(UUID modelId, Context context) {
        return deleteWithResponseAsync(modelId, context).block();
    }

    /**
     * Mark model for deletion. Model artifacts will be permanently removed within a predetermined period.
     * 
     * @param modelId Model identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(UUID modelId) {
        deleteWithResponse(modelId, Context.NONE);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId,
        ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeDocumentWithResponseAsync(modelId, contentType,
            includeTextDetails, pages, fileStream, contentLength, context));
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId,
        ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream,
        Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocument(this.client.getEndpoint(), this.client.getApiVersion(), modelId,
            includeTextDetails, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails,
        List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream,
            contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails,
        List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength, Context context) {
        return analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream,
            contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(UUID modelId,
        ContentType contentType, Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream,
        Long contentLength, Context context) {
        return analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeDocument(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages,
        Flux<ByteBuffer> fileStream, Long contentLength) {
        analyzeDocumentWithResponse(modelId, contentType, includeTextDetails, pages, fileStream, contentLength,
            Context.NONE);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(UUID modelId, ContentType contentType,
        Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType,
            includeTextDetails, pages, fileStream, contentLength, context));
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(UUID modelId, ContentType contentType,
        Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), modelId,
            includeTextDetails, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeDocumentNoCustomHeadersWithResponse(UUID modelId, ContentType contentType,
        Boolean includeTextDetails, List<String> pages, Flux<ByteBuffer> fileStream, Long contentLength,
        Context context) {
        return analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, includeTextDetails, pages,
            fileStream, contentLength, context).block();
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId,
        ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream,
        Long contentLength) {
        return FluxUtil.withContext(context -> analyzeDocumentWithResponseAsync(modelId, contentType,
            includeTextDetails, pages, fileStream, contentLength, context));
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId,
        ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream,
        Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocument(this.client.getEndpoint(), this.client.getApiVersion(), modelId,
            includeTextDetails, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails,
        List<String> pages, BinaryData fileStream, Long contentLength) {
        return analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream,
            contentLength).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, ContentType contentType, Boolean includeTextDetails,
        List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream,
            contentLength, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(UUID modelId,
        ContentType contentType, Boolean includeTextDetails, List<String> pages, BinaryData fileStream,
        Long contentLength, Context context) {
        return analyzeDocumentWithResponseAsync(modelId, contentType, includeTextDetails, pages, fileStream,
            contentLength, context).block();
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeDocument(UUID modelId, ContentType contentType, Boolean includeTextDetails, List<String> pages,
        BinaryData fileStream, Long contentLength) {
        analyzeDocumentWithResponse(modelId, contentType, includeTextDetails, pages, fileStream, contentLength,
            Context.NONE);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(UUID modelId, ContentType contentType,
        Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength) {
        return FluxUtil.withContext(context -> analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType,
            includeTextDetails, pages, fileStream, contentLength, context));
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(UUID modelId, ContentType contentType,
        Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), modelId,
            includeTextDetails, pagesConverted, contentType, fileStream, contentLength, accept, context);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param contentType Upload file type.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeDocumentNoCustomHeadersWithResponse(UUID modelId, ContentType contentType,
        Boolean includeTextDetails, List<String> pages, BinaryData fileStream, Long contentLength, Context context) {
        return analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, contentType, includeTextDetails, pages,
            fileStream, contentLength, context).block();
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId,
        Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(
            context -> analyzeDocumentWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context));
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(UUID modelId,
        Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocument(this.client.getEndpoint(), this.client.getApiVersion(), modelId,
            includeTextDetails, pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, Boolean includeTextDetails, List<String> pages,
        SourcePath fileStream) {
        return analyzeDocumentWithResponseAsync(modelId, includeTextDetails, pages, fileStream)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> analyzeDocumentAsync(UUID modelId, Boolean includeTextDetails, List<String> pages,
        SourcePath fileStream, Context context) {
        return analyzeDocumentWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CustomModelsAnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(UUID modelId,
        Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        return analyzeDocumentWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context).block();
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void analyzeDocument(UUID modelId, Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        analyzeDocumentWithResponse(modelId, includeTextDetails, pages, fileStream, Context.NONE);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(UUID modelId,
        Boolean includeTextDetails, List<String> pages, SourcePath fileStream) {
        return FluxUtil.withContext(context -> analyzeDocumentNoCustomHeadersWithResponseAsync(modelId,
            includeTextDetails, pages, fileStream, context));
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> analyzeDocumentNoCustomHeadersWithResponseAsync(UUID modelId,
        Boolean includeTextDetails, List<String> pages, SourcePath fileStream, Context context) {
        final String accept = "application/json";
        String pagesConverted = (pages == null)
            ? null
            : pages.stream()
                .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                .collect(Collectors.joining(","));
        return service.analyzeDocumentNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), modelId,
            includeTextDetails, pagesConverted, fileStream, accept, context);
    }

    /**
     * Extract key-value pairs, tables, and semantic values from a given document. The input document must be of one of
     * the supported content types - 'application/pdf', 'image/jpeg', 'image/png', 'image/tiff' or 'image/bmp'.
     * Alternatively, use 'application/json' type to specify the location (Uri or local path) of the document to be
     * analyzed.
     * 
     * @param modelId Model identifier.
     * @param includeTextDetails Include text lines and element references in the result.
     * @param pages Custom page numbers for multi-page documents(PDF/TIFF), input the number of the pages you want to
     * get OCR result. For a range of pages, use a hyphen. Separate each page or range with a comma.
     * @param fileStream .json, .pdf, .jpg, .png, .tiff or .bmp type file stream.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> analyzeDocumentNoCustomHeadersWithResponse(UUID modelId, Boolean includeTextDetails,
        List<String> pages, SourcePath fileStream, Context context) {
        return analyzeDocumentNoCustomHeadersWithResponseAsync(modelId, includeTextDetails, pages, fileStream, context)
            .block();
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeResultWithResponseAsync(UUID modelId, UUID resultId) {
        return FluxUtil.withContext(context -> getAnalyzeResultWithResponseAsync(modelId, resultId, context));
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeOperationResult>> getAnalyzeResultWithResponseAsync(UUID modelId, UUID resultId,
        Context context) {
        final String accept = "application/json";
        return service.getAnalyzeResult(this.client.getEndpoint(), this.client.getApiVersion(), modelId, resultId,
            accept, context);
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeResultAsync(UUID modelId, UUID resultId) {
        return getAnalyzeResultWithResponseAsync(modelId, resultId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeOperationResult> getAnalyzeResultAsync(UUID modelId, UUID resultId, Context context) {
        return getAnalyzeResultWithResponseAsync(modelId, resultId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeOperationResult> getAnalyzeResultWithResponse(UUID modelId, UUID resultId, Context context) {
        return getAnalyzeResultWithResponseAsync(modelId, resultId, context).block();
    }

    /**
     * Obtain current status and the result of the analyze form operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Analyze operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued analyze operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeOperationResult getAnalyzeResult(UUID modelId, UUID resultId) {
        return getAnalyzeResultWithResponse(modelId, resultId, Context.NONE).getValue();
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     * 
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsCopyHeaders, Void>> copyWithResponseAsync(UUID modelId,
        CopyRequest copyRequest) {
        return FluxUtil.withContext(context -> copyWithResponseAsync(modelId, copyRequest, context));
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     * 
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsCopyHeaders, Void>> copyWithResponseAsync(UUID modelId,
        CopyRequest copyRequest, Context context) {
        final String accept = "application/json";
        return service.copy(this.client.getEndpoint(), this.client.getApiVersion(), modelId, copyRequest, accept,
            context);
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     * 
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> copyAsync(UUID modelId, CopyRequest copyRequest) {
        return copyWithResponseAsync(modelId, copyRequest).flatMap(ignored -> Mono.empty());
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     * 
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> copyAsync(UUID modelId, CopyRequest copyRequest, Context context) {
        return copyWithResponseAsync(modelId, copyRequest, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     * 
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CustomModelsCopyHeaders, Void> copyWithResponse(UUID modelId, CopyRequest copyRequest,
        Context context) {
        return copyWithResponseAsync(modelId, copyRequest, context).block();
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     * 
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void copy(UUID modelId, CopyRequest copyRequest) {
        copyWithResponse(modelId, copyRequest, Context.NONE);
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     * 
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> copyNoCustomHeadersWithResponseAsync(UUID modelId, CopyRequest copyRequest) {
        return FluxUtil.withContext(context -> copyNoCustomHeadersWithResponseAsync(modelId, copyRequest, context));
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     * 
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> copyNoCustomHeadersWithResponseAsync(UUID modelId, CopyRequest copyRequest,
        Context context) {
        final String accept = "application/json";
        return service.copyNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), modelId, copyRequest,
            accept, context);
    }

    /**
     * Copy custom model stored in this resource (the source) to user specified target Form Recognizer resource.
     * 
     * @param modelId Model identifier.
     * @param copyRequest Copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> copyNoCustomHeadersWithResponse(UUID modelId, CopyRequest copyRequest, Context context) {
        return copyNoCustomHeadersWithResponseAsync(modelId, copyRequest, context).block();
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyOperationResult>> getCopyResultWithResponseAsync(UUID modelId, UUID resultId) {
        return FluxUtil.withContext(context -> getCopyResultWithResponseAsync(modelId, resultId, context));
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyOperationResult>> getCopyResultWithResponseAsync(UUID modelId, UUID resultId,
        Context context) {
        final String accept = "application/json";
        return service.getCopyResult(this.client.getEndpoint(), this.client.getApiVersion(), modelId, resultId, accept,
            context);
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyOperationResult> getCopyResultAsync(UUID modelId, UUID resultId) {
        return getCopyResultWithResponseAsync(modelId, resultId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyOperationResult> getCopyResultAsync(UUID modelId, UUID resultId, Context context) {
        return getCopyResultWithResponseAsync(modelId, resultId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CopyOperationResult> getCopyResultWithResponse(UUID modelId, UUID resultId, Context context) {
        return getCopyResultWithResponseAsync(modelId, resultId, context).block();
    }

    /**
     * Obtain current status and the result of a custom model copy operation.
     * 
     * @param modelId Model identifier.
     * @param resultId Copy operation result identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return status and result of the queued copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CopyOperationResult getCopyResult(UUID modelId, UUID resultId) {
        return getCopyResultWithResponse(modelId, resultId, Context.NONE).getValue();
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation along with {@link ResponseBase}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAuthorizeModelCopyHeaders, CopyAuthorizationResult>>
        authorizeModelCopyWithResponseAsync() {
        return FluxUtil.withContext(context -> authorizeModelCopyWithResponseAsync(context));
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation along with {@link ResponseBase}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsAuthorizeModelCopyHeaders, CopyAuthorizationResult>>
        authorizeModelCopyWithResponseAsync(Context context) {
        final String accept = "application/json";
        return service.authorizeModelCopy(this.client.getEndpoint(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorizationResult> authorizeModelCopyAsync() {
        return authorizeModelCopyWithResponseAsync().flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorizationResult> authorizeModelCopyAsync(Context context) {
        return authorizeModelCopyWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CustomModelsAuthorizeModelCopyHeaders, CopyAuthorizationResult>
        authorizeModelCopyWithResponse(Context context) {
        return authorizeModelCopyWithResponseAsync(context).block();
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CopyAuthorizationResult authorizeModelCopy() {
        return authorizeModelCopyWithResponse(Context.NONE).getValue();
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyAuthorizationResult>> authorizeModelCopyNoCustomHeadersWithResponseAsync() {
        return FluxUtil.withContext(context -> authorizeModelCopyNoCustomHeadersWithResponseAsync(context));
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyAuthorizationResult>> authorizeModelCopyNoCustomHeadersWithResponseAsync(Context context) {
        final String accept = "application/json";
        return service.authorizeModelCopyNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Generate authorization to copy a model into the target Form Recognizer resource.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return request parameter that contains authorization claims for copy operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CopyAuthorizationResult> authorizeModelCopyNoCustomHeadersWithResponse(Context context) {
        return authorizeModelCopyNoCustomHeadersWithResponseAsync(context).block();
    }

    /**
     * Compose request would include list of models ids.
     * It would validate what all models either trained with labels model or composed model.
     * It would validate limit of models put together.
     * 
     * @param composeRequest Compose models.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsComposeHeaders, Void>>
        composeWithResponseAsync(ComposeRequest composeRequest) {
        return FluxUtil.withContext(context -> composeWithResponseAsync(composeRequest, context));
    }

    /**
     * Compose request would include list of models ids.
     * It would validate what all models either trained with labels model or composed model.
     * It would validate limit of models put together.
     * 
     * @param composeRequest Compose models.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CustomModelsComposeHeaders, Void>> composeWithResponseAsync(ComposeRequest composeRequest,
        Context context) {
        final String accept = "application/json, text/json";
        return service.compose(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest, accept, context);
    }

    /**
     * Compose request would include list of models ids.
     * It would validate what all models either trained with labels model or composed model.
     * It would validate limit of models put together.
     * 
     * @param composeRequest Compose models.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> composeAsync(ComposeRequest composeRequest) {
        return composeWithResponseAsync(composeRequest).flatMap(ignored -> Mono.empty());
    }

    /**
     * Compose request would include list of models ids.
     * It would validate what all models either trained with labels model or composed model.
     * It would validate limit of models put together.
     * 
     * @param composeRequest Compose models.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> composeAsync(ComposeRequest composeRequest, Context context) {
        return composeWithResponseAsync(composeRequest, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Compose request would include list of models ids.
     * It would validate what all models either trained with labels model or composed model.
     * It would validate limit of models put together.
     * 
     * @param composeRequest Compose models.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CustomModelsComposeHeaders, Void> composeWithResponse(ComposeRequest composeRequest,
        Context context) {
        return composeWithResponseAsync(composeRequest, context).block();
    }

    /**
     * Compose request would include list of models ids.
     * It would validate what all models either trained with labels model or composed model.
     * It would validate limit of models put together.
     * 
     * @param composeRequest Compose models.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void compose(ComposeRequest composeRequest) {
        composeWithResponse(composeRequest, Context.NONE);
    }

    /**
     * Compose request would include list of models ids.
     * It would validate what all models either trained with labels model or composed model.
     * It would validate limit of models put together.
     * 
     * @param composeRequest Compose models.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> composeNoCustomHeadersWithResponseAsync(ComposeRequest composeRequest) {
        return FluxUtil.withContext(context -> composeNoCustomHeadersWithResponseAsync(composeRequest, context));
    }

    /**
     * Compose request would include list of models ids.
     * It would validate what all models either trained with labels model or composed model.
     * It would validate limit of models put together.
     * 
     * @param composeRequest Compose models.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> composeNoCustomHeadersWithResponseAsync(ComposeRequest composeRequest,
        Context context) {
        final String accept = "application/json, text/json";
        return service.composeNoCustomHeaders(this.client.getEndpoint(), this.client.getApiVersion(), composeRequest,
            accept, context);
    }

    /**
     * Compose request would include list of models ids.
     * It would validate what all models either trained with labels model or composed model.
     * It would validate limit of models put together.
     * 
     * @param composeRequest Compose models.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> composeNoCustomHeadersWithResponse(ComposeRequest composeRequest, Context context) {
        return composeNoCustomHeadersWithResponseAsync(composeRequest, context).block();
    }

    /**
     * Get information about all custom models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listSinglePageAsync() {
        final String op = "full";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.list(this.client.getEndpoint(), this.client.getApiVersion(), op, accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getModelList(), res.getValue().getNextLink(), null));
    }

    /**
     * Get information about all custom models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listSinglePageAsync(Context context) {
        final String op = "full";
        final String accept = "application/json";
        return service.list(this.client.getEndpoint(), this.client.getApiVersion(), op, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getModelList(), res.getValue().getNextLink(), null));
    }

    /**
     * Get information about all custom models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ModelInfo> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get information about all custom models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ModelInfo> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get information about all custom models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ModelInfo> listSinglePage() {
        return listSinglePageAsync().block();
    }

    /**
     * Get information about all custom models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ModelInfo> listSinglePage(Context context) {
        return listSinglePageAsync(context).block();
    }

    /**
     * Get information about all custom models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ModelInfo> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Get information about all custom models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ModelInfo> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Get information about all custom models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Models>> getSummaryWithResponseAsync() {
        return FluxUtil.withContext(context -> getSummaryWithResponseAsync(context));
    }

    /**
     * Get information about all custom models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Models>> getSummaryWithResponseAsync(Context context) {
        final String op = "summary";
        final String accept = "application/json";
        return service.getSummary(this.client.getEndpoint(), this.client.getApiVersion(), op, accept, context);
    }

    /**
     * Get information about all custom models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Models> getSummaryAsync() {
        return getSummaryWithResponseAsync().flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get information about all custom models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Models> getSummaryAsync(Context context) {
        return getSummaryWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get information about all custom models.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Models> getSummaryWithResponse(Context context) {
        return getSummaryWithResponseAsync(context).block();
    }

    /**
     * Get information about all custom models.
     * 
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about all custom models.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Models getSummary() {
        return getSummaryWithResponse(Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to the list custom models operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), this.client.getApiVersion(),
                accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getModelList(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to the list custom models operation along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<ModelInfo>> listNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.listNext(nextLink, this.client.getEndpoint(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getModelList(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to the list custom models operation along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ModelInfo> listNextSinglePage(String nextLink) {
        return listNextSinglePageAsync(nextLink).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response to the list custom models operation along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<ModelInfo> listNextSinglePage(String nextLink, Context context) {
        return listNextSinglePageAsync(nextLink, context).block();
    }
}
