// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Information about the extracted cell in a table.
 */
@Fluent
public final class DataTableCell implements JsonSerializable<DataTableCell> {
    /*
     * Row index of the cell.
     */
    private int rowIndex;

    /*
     * Column index of the cell.
     */
    private int columnIndex;

    /*
     * Number of rows spanned by this cell.
     */
    private Integer rowSpan;

    /*
     * Number of columns spanned by this cell.
     */
    private Integer columnSpan;

    /*
     * Text content of the cell.
     */
    private String text;

    /*
     * Bounding box of the cell.
     */
    private List<Float> boundingBox;

    /*
     * Confidence value.
     */
    private float confidence;

    /*
     * When includeTextDetails is set to true, a list of references to the text elements constituting this table cell.
     */
    private List<String> elements;

    /*
     * Is the current cell a header cell?
     */
    private Boolean isHeader;

    /*
     * Is the current cell a footer cell?
     */
    private Boolean isFooter;

    /**
     * Creates an instance of DataTableCell class.
     */
    public DataTableCell() {
    }

    /**
     * Get the rowIndex property: Row index of the cell.
     * 
     * @return the rowIndex value.
     */
    public int getRowIndex() {
        return this.rowIndex;
    }

    /**
     * Set the rowIndex property: Row index of the cell.
     * 
     * @param rowIndex the rowIndex value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
        return this;
    }

    /**
     * Get the columnIndex property: Column index of the cell.
     * 
     * @return the columnIndex value.
     */
    public int getColumnIndex() {
        return this.columnIndex;
    }

    /**
     * Set the columnIndex property: Column index of the cell.
     * 
     * @param columnIndex the columnIndex value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }

    /**
     * Get the rowSpan property: Number of rows spanned by this cell.
     * 
     * @return the rowSpan value.
     */
    public Integer getRowSpan() {
        return this.rowSpan;
    }

    /**
     * Set the rowSpan property: Number of rows spanned by this cell.
     * 
     * @param rowSpan the rowSpan value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setRowSpan(Integer rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    /**
     * Get the columnSpan property: Number of columns spanned by this cell.
     * 
     * @return the columnSpan value.
     */
    public Integer getColumnSpan() {
        return this.columnSpan;
    }

    /**
     * Set the columnSpan property: Number of columns spanned by this cell.
     * 
     * @param columnSpan the columnSpan value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setColumnSpan(Integer columnSpan) {
        this.columnSpan = columnSpan;
        return this;
    }

    /**
     * Get the text property: Text content of the cell.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: Text content of the cell.
     * 
     * @param text the text value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the boundingBox property: Bounding box of the cell.
     * 
     * @return the boundingBox value.
     */
    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    /**
     * Set the boundingBox property: Bounding box of the cell.
     * 
     * @param boundingBox the boundingBox value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    /**
     * Get the confidence property: Confidence value.
     * 
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: Confidence value.
     * 
     * @param confidence the confidence value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }

    /**
     * Get the elements property: When includeTextDetails is set to true, a list of references to the text elements
     * constituting this table cell.
     * 
     * @return the elements value.
     */
    public List<String> getElements() {
        return this.elements;
    }

    /**
     * Set the elements property: When includeTextDetails is set to true, a list of references to the text elements
     * constituting this table cell.
     * 
     * @param elements the elements value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setElements(List<String> elements) {
        this.elements = elements;
        return this;
    }

    /**
     * Get the isHeader property: Is the current cell a header cell?.
     * 
     * @return the isHeader value.
     */
    public Boolean isHeader() {
        return this.isHeader;
    }

    /**
     * Set the isHeader property: Is the current cell a header cell?.
     * 
     * @param isHeader the isHeader value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setIsHeader(Boolean isHeader) {
        this.isHeader = isHeader;
        return this;
    }

    /**
     * Get the isFooter property: Is the current cell a footer cell?.
     * 
     * @return the isFooter value.
     */
    public Boolean isFooter() {
        return this.isFooter;
    }

    /**
     * Set the isFooter property: Is the current cell a footer cell?.
     * 
     * @param isFooter the isFooter value to set.
     * @return the DataTableCell object itself.
     */
    public DataTableCell setIsFooter(Boolean isFooter) {
        this.isFooter = isFooter;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("rowIndex", this.rowIndex);
        jsonWriter.writeIntField("columnIndex", this.columnIndex);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("boundingBox", this.boundingBox, (writer, element) -> writer.writeFloat(element));
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeNumberField("rowSpan", this.rowSpan);
        jsonWriter.writeNumberField("columnSpan", this.columnSpan);
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isHeader", this.isHeader);
        jsonWriter.writeBooleanField("isFooter", this.isFooter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataTableCell from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataTableCell if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataTableCell.
     */
    public static DataTableCell fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataTableCell deserializedDataTableCell = new DataTableCell();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("rowIndex".equals(fieldName)) {
                    deserializedDataTableCell.rowIndex = reader.getInt();
                } else if ("columnIndex".equals(fieldName)) {
                    deserializedDataTableCell.columnIndex = reader.getInt();
                } else if ("text".equals(fieldName)) {
                    deserializedDataTableCell.text = reader.getString();
                } else if ("boundingBox".equals(fieldName)) {
                    List<Float> boundingBox = reader.readArray(reader1 -> reader1.getFloat());
                    deserializedDataTableCell.boundingBox = boundingBox;
                } else if ("confidence".equals(fieldName)) {
                    deserializedDataTableCell.confidence = reader.getFloat();
                } else if ("rowSpan".equals(fieldName)) {
                    deserializedDataTableCell.rowSpan = reader.getNullable(JsonReader::getInt);
                } else if ("columnSpan".equals(fieldName)) {
                    deserializedDataTableCell.columnSpan = reader.getNullable(JsonReader::getInt);
                } else if ("elements".equals(fieldName)) {
                    List<String> elements = reader.readArray(reader1 -> reader1.getString());
                    deserializedDataTableCell.elements = elements;
                } else if ("isHeader".equals(fieldName)) {
                    deserializedDataTableCell.isHeader = reader.getNullable(JsonReader::getBoolean);
                } else if ("isFooter".equals(fieldName)) {
                    deserializedDataTableCell.isFooter = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataTableCell;
        });
    }
}
