// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Recognized field value.
 */
@Fluent
public final class FieldValue implements JsonSerializable<FieldValue> {
    /*
     * Type of field value.
     */
    private FieldValueType type;

    /*
     * String value.
     */
    private String valueString;

    /*
     * Date value.
     */
    private LocalDate valueDate;

    /*
     * Time value.
     */
    private String valueTime;

    /*
     * Phone number value.
     */
    private String valuePhoneNumber;

    /*
     * Floating point value.
     */
    private Float valueNumber;

    /*
     * Integer value.
     */
    private Integer valueInteger;

    /*
     * Array of field values.
     */
    private List<FieldValue> valueArray;

    /*
     * Dictionary of named field values.
     */
    private Map<String, FieldValue> valueObject;

    /*
     * Selection mark value.
     */
    private FieldValueSelectionMark valueSelectionMark;

    /*
     * 3-letter country code (ISO 3166-1 alpha-3).
     */
    private String valueCountryRegion;

    /*
     * Text content of the extracted field.
     */
    private String text;

    /*
     * Bounding box of the field value, if appropriate.
     */
    private List<Float> boundingBox;

    /*
     * Confidence score.
     */
    private Float confidence;

    /*
     * When includeTextDetails is set to true, a list of references to the text elements constituting this field.
     */
    private List<String> elements;

    /*
     * The 1-based page number in the input document.
     */
    private Integer page;

    /**
     * Creates an instance of FieldValue class.
     */
    public FieldValue() {
    }

    /**
     * Get the type property: Type of field value.
     * 
     * @return the type value.
     */
    public FieldValueType getType() {
        return this.type;
    }

    /**
     * Set the type property: Type of field value.
     * 
     * @param type the type value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setType(FieldValueType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the valueString property: String value.
     * 
     * @return the valueString value.
     */
    public String getValueString() {
        return this.valueString;
    }

    /**
     * Set the valueString property: String value.
     * 
     * @param valueString the valueString value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValueString(String valueString) {
        this.valueString = valueString;
        return this;
    }

    /**
     * Get the valueDate property: Date value.
     * 
     * @return the valueDate value.
     */
    public LocalDate getValueDate() {
        return this.valueDate;
    }

    /**
     * Set the valueDate property: Date value.
     * 
     * @param valueDate the valueDate value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    /**
     * Get the valueTime property: Time value.
     * 
     * @return the valueTime value.
     */
    public String getValueTime() {
        return this.valueTime;
    }

    /**
     * Set the valueTime property: Time value.
     * 
     * @param valueTime the valueTime value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValueTime(String valueTime) {
        this.valueTime = valueTime;
        return this;
    }

    /**
     * Get the valuePhoneNumber property: Phone number value.
     * 
     * @return the valuePhoneNumber value.
     */
    public String getValuePhoneNumber() {
        return this.valuePhoneNumber;
    }

    /**
     * Set the valuePhoneNumber property: Phone number value.
     * 
     * @param valuePhoneNumber the valuePhoneNumber value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValuePhoneNumber(String valuePhoneNumber) {
        this.valuePhoneNumber = valuePhoneNumber;
        return this;
    }

    /**
     * Get the valueNumber property: Floating point value.
     * 
     * @return the valueNumber value.
     */
    public Float getValueNumber() {
        return this.valueNumber;
    }

    /**
     * Set the valueNumber property: Floating point value.
     * 
     * @param valueNumber the valueNumber value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValueNumber(Float valueNumber) {
        this.valueNumber = valueNumber;
        return this;
    }

    /**
     * Get the valueInteger property: Integer value.
     * 
     * @return the valueInteger value.
     */
    public Integer getValueInteger() {
        return this.valueInteger;
    }

    /**
     * Set the valueInteger property: Integer value.
     * 
     * @param valueInteger the valueInteger value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValueInteger(Integer valueInteger) {
        this.valueInteger = valueInteger;
        return this;
    }

    /**
     * Get the valueArray property: Array of field values.
     * 
     * @return the valueArray value.
     */
    public List<FieldValue> getValueArray() {
        return this.valueArray;
    }

    /**
     * Set the valueArray property: Array of field values.
     * 
     * @param valueArray the valueArray value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValueArray(List<FieldValue> valueArray) {
        this.valueArray = valueArray;
        return this;
    }

    /**
     * Get the valueObject property: Dictionary of named field values.
     * 
     * @return the valueObject value.
     */
    public Map<String, FieldValue> getValueObject() {
        return this.valueObject;
    }

    /**
     * Set the valueObject property: Dictionary of named field values.
     * 
     * @param valueObject the valueObject value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValueObject(Map<String, FieldValue> valueObject) {
        this.valueObject = valueObject;
        return this;
    }

    /**
     * Get the valueSelectionMark property: Selection mark value.
     * 
     * @return the valueSelectionMark value.
     */
    public FieldValueSelectionMark getValueSelectionMark() {
        return this.valueSelectionMark;
    }

    /**
     * Set the valueSelectionMark property: Selection mark value.
     * 
     * @param valueSelectionMark the valueSelectionMark value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValueSelectionMark(FieldValueSelectionMark valueSelectionMark) {
        this.valueSelectionMark = valueSelectionMark;
        return this;
    }

    /**
     * Get the valueCountryRegion property: 3-letter country code (ISO 3166-1 alpha-3).
     * 
     * @return the valueCountryRegion value.
     */
    public String getValueCountryRegion() {
        return this.valueCountryRegion;
    }

    /**
     * Set the valueCountryRegion property: 3-letter country code (ISO 3166-1 alpha-3).
     * 
     * @param valueCountryRegion the valueCountryRegion value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setValueCountryRegion(String valueCountryRegion) {
        this.valueCountryRegion = valueCountryRegion;
        return this;
    }

    /**
     * Get the text property: Text content of the extracted field.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: Text content of the extracted field.
     * 
     * @param text the text value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the boundingBox property: Bounding box of the field value, if appropriate.
     * 
     * @return the boundingBox value.
     */
    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    /**
     * Set the boundingBox property: Bounding box of the field value, if appropriate.
     * 
     * @param boundingBox the boundingBox value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    /**
     * Get the confidence property: Confidence score.
     * 
     * @return the confidence value.
     */
    public Float getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: Confidence score.
     * 
     * @param confidence the confidence value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setConfidence(Float confidence) {
        this.confidence = confidence;
        return this;
    }

    /**
     * Get the elements property: When includeTextDetails is set to true, a list of references to the text elements
     * constituting this field.
     * 
     * @return the elements value.
     */
    public List<String> getElements() {
        return this.elements;
    }

    /**
     * Set the elements property: When includeTextDetails is set to true, a list of references to the text elements
     * constituting this field.
     * 
     * @param elements the elements value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setElements(List<String> elements) {
        this.elements = elements;
        return this;
    }

    /**
     * Get the page property: The 1-based page number in the input document.
     * 
     * @return the page value.
     */
    public Integer getPage() {
        return this.page;
    }

    /**
     * Set the page property: The 1-based page number in the input document.
     * 
     * @param page the page value to set.
     * @return the FieldValue object itself.
     */
    public FieldValue setPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("valueString", this.valueString);
        jsonWriter.writeStringField("valueDate", Objects.toString(this.valueDate, null));
        jsonWriter.writeStringField("valueTime", this.valueTime);
        jsonWriter.writeStringField("valuePhoneNumber", this.valuePhoneNumber);
        jsonWriter.writeNumberField("valueNumber", this.valueNumber);
        jsonWriter.writeNumberField("valueInteger", this.valueInteger);
        jsonWriter.writeArrayField("valueArray", this.valueArray, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("valueObject", this.valueObject, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("valueSelectionMark",
            this.valueSelectionMark == null ? null : this.valueSelectionMark.toString());
        jsonWriter.writeStringField("valueCountryRegion", this.valueCountryRegion);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("boundingBox", this.boundingBox, (writer, element) -> writer.writeFloat(element));
        jsonWriter.writeNumberField("confidence", this.confidence);
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("page", this.page);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FieldValue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FieldValue if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FieldValue.
     */
    public static FieldValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FieldValue deserializedFieldValue = new FieldValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedFieldValue.type = FieldValueType.fromString(reader.getString());
                } else if ("valueString".equals(fieldName)) {
                    deserializedFieldValue.valueString = reader.getString();
                } else if ("valueDate".equals(fieldName)) {
                    deserializedFieldValue.valueDate
                        = reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                } else if ("valueTime".equals(fieldName)) {
                    deserializedFieldValue.valueTime = reader.getString();
                } else if ("valuePhoneNumber".equals(fieldName)) {
                    deserializedFieldValue.valuePhoneNumber = reader.getString();
                } else if ("valueNumber".equals(fieldName)) {
                    deserializedFieldValue.valueNumber = reader.getNullable(JsonReader::getFloat);
                } else if ("valueInteger".equals(fieldName)) {
                    deserializedFieldValue.valueInteger = reader.getNullable(JsonReader::getInt);
                } else if ("valueArray".equals(fieldName)) {
                    List<FieldValue> valueArray = reader.readArray(reader1 -> FieldValue.fromJson(reader1));
                    deserializedFieldValue.valueArray = valueArray;
                } else if ("valueObject".equals(fieldName)) {
                    Map<String, FieldValue> valueObject = reader.readMap(reader1 -> FieldValue.fromJson(reader1));
                    deserializedFieldValue.valueObject = valueObject;
                } else if ("valueSelectionMark".equals(fieldName)) {
                    deserializedFieldValue.valueSelectionMark = FieldValueSelectionMark.fromString(reader.getString());
                } else if ("valueCountryRegion".equals(fieldName)) {
                    deserializedFieldValue.valueCountryRegion = reader.getString();
                } else if ("text".equals(fieldName)) {
                    deserializedFieldValue.text = reader.getString();
                } else if ("boundingBox".equals(fieldName)) {
                    List<Float> boundingBox = reader.readArray(reader1 -> reader1.getFloat());
                    deserializedFieldValue.boundingBox = boundingBox;
                } else if ("confidence".equals(fieldName)) {
                    deserializedFieldValue.confidence = reader.getNullable(JsonReader::getFloat);
                } else if ("elements".equals(fieldName)) {
                    List<String> elements = reader.readArray(reader1 -> reader1.getString());
                    deserializedFieldValue.elements = elements;
                } else if ("page".equals(fieldName)) {
                    deserializedFieldValue.page = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFieldValue;
        });
    }
}
