// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.UUID;

/**
 * Basic custom model information.
 */
@Fluent
public final class ModelInfo implements JsonSerializable<ModelInfo> {
    /*
     * Model identifier.
     */
    private UUID modelId;

    /*
     * Status of the model.
     */
    private ModelStatus status;

    /*
     * Date and time (UTC) when the model was created.
     */
    private OffsetDateTime createdDateTime;

    /*
     * Date and time (UTC) when the status was last updated.
     */
    private OffsetDateTime lastUpdatedDateTime;

    /*
     * Optional user defined model name (max length: 1024).
     */
    private String modelName;

    /*
     * Optional model attributes.
     */
    private Attributes attributes;

    /**
     * Creates an instance of ModelInfo class.
     */
    public ModelInfo() {
    }

    /**
     * Get the modelId property: Model identifier.
     * 
     * @return the modelId value.
     */
    public UUID getModelId() {
        return this.modelId;
    }

    /**
     * Set the modelId property: Model identifier.
     * 
     * @param modelId the modelId value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setModelId(UUID modelId) {
        this.modelId = modelId;
        return this;
    }

    /**
     * Get the status property: Status of the model.
     * 
     * @return the status value.
     */
    public ModelStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Status of the model.
     * 
     * @param status the status value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setStatus(ModelStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the createdDateTime property: Date and time (UTC) when the model was created.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Date and time (UTC) when the model was created.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the lastUpdatedDateTime property: Date and time (UTC) when the status was last updated.
     * 
     * @return the lastUpdatedDateTime value.
     */
    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    /**
     * Set the lastUpdatedDateTime property: Date and time (UTC) when the status was last updated.
     * 
     * @param lastUpdatedDateTime the lastUpdatedDateTime value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    /**
     * Get the modelName property: Optional user defined model name (max length: 1024).
     * 
     * @return the modelName value.
     */
    public String getModelName() {
        return this.modelName;
    }

    /**
     * Set the modelName property: Optional user defined model name (max length: 1024).
     * 
     * @param modelName the modelName value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setModelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    /**
     * Get the attributes property: Optional model attributes.
     * 
     * @return the attributes value.
     */
    public Attributes getAttributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: Optional model attributes.
     * 
     * @param attributes the attributes value to set.
     * @return the ModelInfo object itself.
     */
    public ModelInfo setAttributes(Attributes attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", Objects.toString(this.modelId, null));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime",
            this.lastUpdatedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeStringField("modelName", this.modelName);
        jsonWriter.writeJsonField("attributes", this.attributes);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ModelInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ModelInfo if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ModelInfo.
     */
    public static ModelInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ModelInfo deserializedModelInfo = new ModelInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("modelId".equals(fieldName)) {
                    deserializedModelInfo.modelId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("status".equals(fieldName)) {
                    deserializedModelInfo.status = ModelStatus.fromString(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedModelInfo.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedModelInfo.lastUpdatedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("modelName".equals(fieldName)) {
                    deserializedModelInfo.modelName = reader.getString();
                } else if ("attributes".equals(fieldName)) {
                    deserializedModelInfo.attributes = Attributes.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedModelInfo;
        });
    }
}
