// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An object representing a word.
 */
@Fluent
public final class TextWord implements JsonSerializable<TextWord> {
    /*
     * The text content of the word.
     */
    private String text;

    /*
     * Bounding box of an extracted word.
     */
    private List<Float> boundingBox;

    /*
     * Confidence value.
     */
    private Float confidence;

    /**
     * Creates an instance of TextWord class.
     */
    public TextWord() {
    }

    /**
     * Get the text property: The text content of the word.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The text content of the word.
     * 
     * @param text the text value to set.
     * @return the TextWord object itself.
     */
    public TextWord setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the boundingBox property: Bounding box of an extracted word.
     * 
     * @return the boundingBox value.
     */
    public List<Float> getBoundingBox() {
        return this.boundingBox;
    }

    /**
     * Set the boundingBox property: Bounding box of an extracted word.
     * 
     * @param boundingBox the boundingBox value to set.
     * @return the TextWord object itself.
     */
    public TextWord setBoundingBox(List<Float> boundingBox) {
        this.boundingBox = boundingBox;
        return this;
    }

    /**
     * Get the confidence property: Confidence value.
     * 
     * @return the confidence value.
     */
    public Float getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: Confidence value.
     * 
     * @param confidence the confidence value to set.
     * @return the TextWord object itself.
     */
    public TextWord setConfidence(Float confidence) {
        this.confidence = confidence;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("boundingBox", this.boundingBox, (writer, element) -> writer.writeFloat(element));
        jsonWriter.writeNumberField("confidence", this.confidence);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TextWord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TextWord if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TextWord.
     */
    public static TextWord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TextWord deserializedTextWord = new TextWord();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedTextWord.text = reader.getString();
                } else if ("boundingBox".equals(fieldName)) {
                    List<Float> boundingBox = reader.readArray(reader1 -> reader1.getFloat());
                    deserializedTextWord.boundingBox = boundingBox;
                } else if ("confidence".equals(fieldName)) {
                    deserializedTextWord.confidence = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTextWord;
        });
    }
}
