// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Report for a custom model training document.
 */
@Fluent
public final class TrainingDocumentInfo implements JsonSerializable<TrainingDocumentInfo> {
    /*
     * Training document name.
     */
    private String documentName;

    /*
     * Total number of pages trained.
     */
    private int pages;

    /*
     * List of errors.
     */
    private List<ErrorInformation> errors;

    /*
     * Status of the training operation.
     */
    private TrainStatus status;

    /**
     * Creates an instance of TrainingDocumentInfo class.
     */
    public TrainingDocumentInfo() {
    }

    /**
     * Get the documentName property: Training document name.
     * 
     * @return the documentName value.
     */
    public String getDocumentName() {
        return this.documentName;
    }

    /**
     * Set the documentName property: Training document name.
     * 
     * @param documentName the documentName value to set.
     * @return the TrainingDocumentInfo object itself.
     */
    public TrainingDocumentInfo setDocumentName(String documentName) {
        this.documentName = documentName;
        return this;
    }

    /**
     * Get the pages property: Total number of pages trained.
     * 
     * @return the pages value.
     */
    public int getPages() {
        return this.pages;
    }

    /**
     * Set the pages property: Total number of pages trained.
     * 
     * @param pages the pages value to set.
     * @return the TrainingDocumentInfo object itself.
     */
    public TrainingDocumentInfo setPages(int pages) {
        this.pages = pages;
        return this;
    }

    /**
     * Get the errors property: List of errors.
     * 
     * @return the errors value.
     */
    public List<ErrorInformation> getErrors() {
        return this.errors;
    }

    /**
     * Set the errors property: List of errors.
     * 
     * @param errors the errors value to set.
     * @return the TrainingDocumentInfo object itself.
     */
    public TrainingDocumentInfo setErrors(List<ErrorInformation> errors) {
        this.errors = errors;
        return this;
    }

    /**
     * Get the status property: Status of the training operation.
     * 
     * @return the status value.
     */
    public TrainStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Status of the training operation.
     * 
     * @param status the status value to set.
     * @return the TrainingDocumentInfo object itself.
     */
    public TrainingDocumentInfo setStatus(TrainStatus status) {
        this.status = status;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("documentName", this.documentName);
        jsonWriter.writeIntField("pages", this.pages);
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TrainingDocumentInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TrainingDocumentInfo if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TrainingDocumentInfo.
     */
    public static TrainingDocumentInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrainingDocumentInfo deserializedTrainingDocumentInfo = new TrainingDocumentInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("documentName".equals(fieldName)) {
                    deserializedTrainingDocumentInfo.documentName = reader.getString();
                } else if ("pages".equals(fieldName)) {
                    deserializedTrainingDocumentInfo.pages = reader.getInt();
                } else if ("errors".equals(fieldName)) {
                    List<ErrorInformation> errors = reader.readArray(reader1 -> ErrorInformation.fromJson(reader1));
                    deserializedTrainingDocumentInfo.errors = errors;
                } else if ("status".equals(fieldName)) {
                    deserializedTrainingDocumentInfo.status = TrainStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTrainingDocumentInfo;
        });
    }
}
