// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The text line style name, including handwriting and other.
 */
public final class TextStyleName extends ExpandableStringEnum<TextStyleName> {
    /**
     * Static value other for TextStyleName.
     */
    public static final TextStyleName OTHER = fromString("other");

    /**
     * Static value handwriting for TextStyleName.
     */
    public static final TextStyleName HANDWRITING = fromString("handwriting");

    /**
     * Creates a new instance of TextStyleName value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public TextStyleName() {
    }

    /**
     * Creates or finds a TextStyleName from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding TextStyleName.
     */
    public static TextStyleName fromString(String name) {
        return fromString(name, TextStyleName.class);
    }

    /**
     * Gets known TextStyleName values.
     * 
     * @return known TextStyleName values.
     */
    public static Collection<TextStyleName> values() {
        return values(TextStyleName.class);
    }
}
