/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.administration;

import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisAsyncClient;
import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisClientBuilder;
import com.azure.ai.formrecognizer.documentanalysis.DocumentAnalysisServiceVersion;
import com.azure.ai.formrecognizer.documentanalysis.administration.DocumentModelAdministrationClientBuilder;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.BlobContentSource;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.BlobFileListContentSource;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.BuildDocumentClassifierOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.BuildDocumentModelOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ClassifierDocumentTypeDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ComposeDocumentModelOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ContentSource;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.CopyAuthorizationOptions;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentClassifierDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelBuildMode;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelCopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.DocumentModelSummary;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.OperationSummary;
import com.azure.ai.formrecognizer.documentanalysis.administration.models.ResourceDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.DocumentClassifiersImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.DocumentModelsImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.MiscellaneousImpl;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentClassifierRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifiersBuildClassifierHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsBuildModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsComposeModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelsCopyModelToHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Constants;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Transforms;
import com.azure.ai.formrecognizer.documentanalysis.implementation.util.Utility;
import com.azure.ai.formrecognizer.documentanalysis.models.DocumentAnalysisAudience;
import com.azure.ai.formrecognizer.documentanalysis.models.OperationResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DocumentModelAdministrationClientBuilder.class, isAsync=true)
public final class DocumentModelAdministrationAsyncClient {
    private final ClientLogger logger = new ClientLogger(DocumentModelAdministrationAsyncClient.class);
    private final FormRecognizerClientImpl formRecognizerClientImpl;
    private final DocumentModelsImpl documentModelsImpl;
    private final MiscellaneousImpl miscellaneousImpl;
    private final DocumentClassifiersImpl documentClassifiersImpl;
    private final DocumentAnalysisServiceVersion serviceVersion;
    private final DocumentAnalysisAudience audience;

    DocumentModelAdministrationAsyncClient(FormRecognizerClientImpl formRecognizerClientImpl, DocumentAnalysisServiceVersion serviceVersion, DocumentAnalysisAudience audience) {
        this.formRecognizerClientImpl = formRecognizerClientImpl;
        this.documentModelsImpl = formRecognizerClientImpl.getDocumentModels();
        this.miscellaneousImpl = formRecognizerClientImpl.getMiscellaneous();
        this.serviceVersion = serviceVersion;
        this.documentClassifiersImpl = formRecognizerClientImpl.getDocumentClassifiers();
        this.audience = audience;
    }

    public DocumentAnalysisAsyncClient getDocumentAnalysisAsyncClient() {
        return new DocumentAnalysisClientBuilder().endpoint(this.getEndpoint()).pipeline(this.getHttpPipeline()).audience(this.audience).buildAsyncClient();
    }

    HttpPipeline getHttpPipeline() {
        return this.formRecognizerClientImpl.getHttpPipeline();
    }

    String getEndpoint() {
        return this.formRecognizerClientImpl.getEndpoint();
    }

    DocumentAnalysisAudience getAudience() {
        return this.audience;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, DocumentModelDetails> beginBuildDocumentModel(String blobContainerUrl, DocumentModelBuildMode buildMode) {
        return this.beginBuildDocumentModel(blobContainerUrl, buildMode, null, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, DocumentModelDetails> beginBuildDocumentModel(String blobContainerUrl, DocumentModelBuildMode buildMode, String prefix, BuildDocumentModelOptions buildDocumentModelOptions) {
        if (blobContainerUrl == null) {
            return PollerFlux.error((Exception)new NullPointerException("'blobContainerUrl' is required and cannot be null."));
        }
        return this.beginBuildDocumentModel(new BlobContentSource(blobContainerUrl).setPrefix(prefix), buildMode, buildDocumentModelOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, DocumentModelDetails> beginBuildDocumentModel(ContentSource contentSource, DocumentModelBuildMode buildMode) {
        return this.beginBuildDocumentModel(contentSource, buildMode, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, DocumentModelDetails> beginBuildDocumentModel(ContentSource contentSource, DocumentModelBuildMode buildMode, BuildDocumentModelOptions buildDocumentModelOptions) {
        return this.beginBuildDocumentModel(contentSource, buildMode, buildDocumentModelOptions, Context.NONE);
    }

    private PollerFlux<OperationResult, DocumentModelDetails> beginBuildDocumentModel(ContentSource contentSource, DocumentModelBuildMode buildMode, BuildDocumentModelOptions buildDocumentModelOptions, Context context) {
        BlobContentSource blobContentSource;
        String modelId = (buildDocumentModelOptions = buildDocumentModelOptions == null ? new BuildDocumentModelOptions() : buildDocumentModelOptions).getModelId();
        if (modelId == null) {
            modelId = Utility.generateRandomModelID();
        }
        if (contentSource instanceof BlobFileListContentSource) {
            BlobFileListContentSource blobFileListContentSource = (BlobFileListContentSource)contentSource;
            if (blobFileListContentSource.getContainerUrl() == null) {
                return PollerFlux.error((Exception)new NullPointerException("'blobContainerUrl' is required and cannot be null."));
            }
            if (blobFileListContentSource.getFileList() == null) {
                return PollerFlux.error((Exception)new NullPointerException("'fileList' is required and cannot be null."));
            }
        }
        if (contentSource instanceof BlobContentSource && (blobContentSource = (BlobContentSource)contentSource).getContainerUrl() == null) {
            return PollerFlux.error((Exception)new NullPointerException("'blobContainerUrl' is required and cannot be null."));
        }
        return new PollerFlux(Constants.DEFAULT_POLL_INTERVAL, this.buildModelActivationOperation(contentSource, buildMode, modelId, buildDocumentModelOptions, context), this.createModelPollOperation(context), DocumentModelAdministrationAsyncClient.cancellationNotSupported(), this.fetchModelResultOperation(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResourceDetails> getResourceDetails() {
        return this.getResourceDetailsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ResourceDetails>> getResourceDetailsWithResponse() {
        try {
            return FluxUtil.withContext(this::getResourceDetailsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<ResourceDetails>> getResourceDetailsWithResponse(Context context) {
        return this.miscellaneousImpl.getResourceInfoWithResponseAsync(context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)Transforms.toAccountProperties((com.azure.ai.formrecognizer.documentanalysis.implementation.models.ResourceDetails)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDocumentModel(String modelId) {
        return this.deleteDocumentModelWithResponse(modelId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDocumentModelWithResponse(String modelId) {
        try {
            return FluxUtil.withContext(context -> this.deleteDocumentModelWithResponse(modelId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<Void>> deleteDocumentModelWithResponse(String modelId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty."));
        }
        return this.documentModelsImpl.deleteModelWithResponseAsync(modelId, context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentModelCopyAuthorization> getCopyAuthorization() {
        return this.getCopyAuthorizationWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentModelCopyAuthorization>> getCopyAuthorizationWithResponse(CopyAuthorizationOptions copyAuthorizationOptions) {
        try {
            return FluxUtil.withContext(context -> this.getCopyAuthorizationWithResponse(copyAuthorizationOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<DocumentModelCopyAuthorization>> getCopyAuthorizationWithResponse(CopyAuthorizationOptions copyAuthorizationOptions, Context context) {
        copyAuthorizationOptions = copyAuthorizationOptions == null ? new CopyAuthorizationOptions() : copyAuthorizationOptions;
        String modelId = copyAuthorizationOptions.getModelId();
        modelId = modelId == null ? Utility.generateRandomModelID() : modelId;
        AuthorizeCopyRequest authorizeCopyRequest = Transforms.getAuthorizeCopyRequest(copyAuthorizationOptions, modelId);
        return this.documentModelsImpl.authorizeModelCopyWithResponseAsync(authorizeCopyRequest, context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)Transforms.toCopyAuthorization((CopyAuthorization)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, DocumentModelDetails> beginComposeDocumentModel(List<String> componentModelIds) {
        return this.beginComposeDocumentModel(componentModelIds, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, DocumentModelDetails> beginComposeDocumentModel(List<String> componentModelIds, ComposeDocumentModelOptions composeDocumentModelOptions) {
        return this.beginComposeDocumentModel(componentModelIds, composeDocumentModelOptions, Context.NONE);
    }

    private PollerFlux<OperationResult, DocumentModelDetails> beginComposeDocumentModel(List<String> componentModelIds, ComposeDocumentModelOptions composeDocumentModelOptions, Context context) {
        try {
            if (CoreUtils.isNullOrEmpty(componentModelIds)) {
                return PollerFlux.error((Exception)new NullPointerException("'componentModelIds' cannot be null or empty"));
            }
            String modelId = composeDocumentModelOptions.getModelId();
            modelId = modelId == null ? Utility.generateRandomModelID() : modelId;
            ComposeDocumentModelRequest composeRequest = Transforms.getComposeDocumentModelRequest(componentModelIds, Utility.getComposeModelOptions(composeDocumentModelOptions), modelId);
            return new PollerFlux(Constants.DEFAULT_POLL_INTERVAL, Utility.activationOperation(() -> this.documentModelsImpl.composeModelWithResponseAsync(composeRequest, context).map(response -> Transforms.toDocumentOperationResult(((DocumentModelsComposeModelHeaders)response.getDeserializedHeaders()).getOperationLocation())), this.logger), this.createModelPollOperation(context), DocumentModelAdministrationAsyncClient.cancellationNotSupported(), this.fetchModelResultOperation(context));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, DocumentModelDetails> beginCopyDocumentModelTo(String sourceModelId, DocumentModelCopyAuthorization target) {
        return this.beginCopyDocumentModelTo(sourceModelId, target, null);
    }

    private PollerFlux<OperationResult, DocumentModelDetails> beginCopyDocumentModelTo(String sourceModelId, DocumentModelCopyAuthorization target, Context context) {
        return new PollerFlux(Constants.DEFAULT_POLL_INTERVAL, this.getCopyActivationOperation(sourceModelId, target, context), this.createModelPollOperation(context), DocumentModelAdministrationAsyncClient.cancellationNotSupported(), this.fetchModelResultOperation(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> listDocumentModels() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listFirstPageModelInfo), continuationToken -> FluxUtil.withContext(context -> this.listNextPageModelInfo((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getDocumentModel(String modelId) {
        return this.getDocumentModelWithResponse(modelId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getDocumentModelWithResponse(String modelId) {
        try {
            return FluxUtil.withContext(context -> this.getDocumentModelWithResponse(modelId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<DocumentModelDetails>> getDocumentModelWithResponse(String modelId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)modelId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'modelId' is required and cannot be null or empty"));
        }
        return this.documentModelsImpl.getModelWithResponseAsync(modelId, context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)Transforms.toDocumentModelDetails((com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationDetails> getOperation(String operationId) {
        return this.getOperationWithResponse(operationId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationWithResponse(String operationId) {
        try {
            return FluxUtil.withContext(context -> this.getOperationWithResponse(operationId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<OperationDetails>> getOperationWithResponse(String operationId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)operationId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'operationId' is required and cannot be null or empty"));
        }
        return this.miscellaneousImpl.getOperationWithResponseAsync(operationId, context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)Transforms.toOperationDetails((com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OperationSummary> listOperations() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listFirstPageOperationInfo), continuationToken -> FluxUtil.withContext(context -> this.listNextPageOperationInfo((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDocumentClassifier(String classifierId) {
        return this.deleteDocumentModelWithResponse(classifierId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDocumentClassifierWithResponse(String classifierId) {
        try {
            return FluxUtil.withContext(context -> this.deleteDocumentModelWithResponse(classifierId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentClassifierDetails> listDocumentClassifiers() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(this::listFirstPageClassifiers), continuationToken -> FluxUtil.withContext(context -> this.listNextPageClassifiers((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<DocumentClassifierDetails>> listFirstPageClassifiers(Context context) {
        return this.documentClassifiersImpl.listClassifiersSinglePageAsync(context).doOnRequest(ignoredValue -> this.logger.info("Listing information for all models")).doOnSuccess(response -> this.logger.info("Listed all models")).doOnError(error -> this.logger.warning("Failed to list all models information", new Object[]{error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().stream().map(Transforms::fromInnerDocumentClassifierDetails).collect(Collectors.toList()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<DocumentClassifierDetails>> listNextPageClassifiers(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.documentClassifiersImpl.listClassifiersNextSinglePageAsync(nextPageLink, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().stream().map(Transforms::fromInnerDocumentClassifierDetails).collect(Collectors.toList()), (String)res.getContinuationToken(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentClassifierDetails> getDocumentClassifier(String classifierId) {
        return this.getDocumentClassifierWithResponse(classifierId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DocumentClassifierDetails>> getDocumentClassifierWithResponse(String classifierId) {
        try {
            return FluxUtil.withContext(context -> this.getDocumentClassifierWithResponse(classifierId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<DocumentClassifierDetails>> getDocumentClassifierWithResponse(String classifierId, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)classifierId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'classifierId' is required and cannot be null or empty"));
        }
        return this.documentClassifiersImpl.getClassifierWithResponseAsync(classifierId, context).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(response -> new SimpleResponse(response, (Object)Transforms.fromInnerDocumentClassifierDetails((com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentClassifierDetails)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, DocumentClassifierDetails> beginBuildDocumentClassifier(Map<String, ClassifierDocumentTypeDetails> documentTypes) {
        return this.beginBuildDocumentClassifier(documentTypes, null, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<OperationResult, DocumentClassifierDetails> beginBuildDocumentClassifier(Map<String, ClassifierDocumentTypeDetails> documentTypes, BuildDocumentClassifierOptions buildDocumentClassifierOptions) {
        return this.beginBuildDocumentClassifier(documentTypes, buildDocumentClassifierOptions, Context.NONE);
    }

    private PollerFlux<OperationResult, DocumentClassifierDetails> beginBuildDocumentClassifier(Map<String, ClassifierDocumentTypeDetails> documentTypes, BuildDocumentClassifierOptions buildDocumentClassifierOptions, Context context) {
        String classifierId = (buildDocumentClassifierOptions = buildDocumentClassifierOptions == null ? new BuildDocumentClassifierOptions() : buildDocumentClassifierOptions).getClassifierId();
        if (classifierId == null) {
            classifierId = Utility.generateRandomModelID();
        }
        return new PollerFlux(Constants.DEFAULT_POLL_INTERVAL, this.buildClassifierActivationOperation(classifierId, documentTypes, buildDocumentClassifierOptions, context), this.createModelPollOperation(context), DocumentModelAdministrationAsyncClient.cancellationNotSupported(), this.fetchClassifierResultOperation(context));
    }

    private Function<PollingContext<OperationResult>, Mono<DocumentClassifierDetails>> fetchClassifierResultOperation(Context context) {
        return pollingContext -> {
            try {
                String classifierId = ((OperationResult)pollingContext.getLatestResponse().getValue()).getOperationId();
                return this.miscellaneousImpl.getOperationWithResponseAsync(classifierId, context).map(classifierResponse -> Transforms.toDocumentClassifierFromOperationId((com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails)classifierResponse.getValue()));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<DocumentModelDetails>> fetchModelResultOperation(Context context) {
        return pollingContext -> {
            try {
                String modelId = ((OperationResult)pollingContext.getLatestResponse().getValue()).getOperationId();
                return this.miscellaneousImpl.getOperationWithResponseAsync(modelId, context).map(modelSimpleResponse -> Transforms.toDocumentModelFromOperationId((com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails)modelSimpleResponse.getValue())).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<PollResponse<OperationResult>>> createModelPollOperation(Context context) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                String modelId = ((OperationResult)operationResultPollResponse.getValue()).getOperationId();
                return this.miscellaneousImpl.getOperationAsync(modelId, context).flatMap(modelSimpleResponse -> this.processBuildingModelResponse((com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails)modelSimpleResponse, (PollResponse<OperationResult>)operationResultPollResponse)).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (HttpResponseException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)((Object)ex));
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> buildModelActivationOperation(ContentSource contentSource, DocumentModelBuildMode buildMode, String modelId, BuildDocumentModelOptions buildDocumentModelOptions, Context context) {
        return pollingContext -> {
            try {
                BuildDocumentModelRequest buildDocumentModelRequest = Transforms.getBuildDocumentModelRequest(contentSource, buildMode, modelId, buildDocumentModelOptions);
                return this.documentModelsImpl.buildModelWithResponseAsync(buildDocumentModelRequest, context).map(response -> Transforms.toDocumentOperationResult(((DocumentModelsBuildModelHeaders)response.getDeserializedHeaders()).getOperationLocation())).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> buildClassifierActivationOperation(String classifierId, Map<String, ClassifierDocumentTypeDetails> documentTypes, BuildDocumentClassifierOptions buildDocumentClassifierOptions, Context context) {
        return pollingContext -> {
            try {
                if (documentTypes == null) {
                    return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'documentTypes' cannot be null."));
                }
                BuildDocumentClassifierRequest buildDocumentModelRequest = Transforms.getBuildDocumentClassifierRequest(classifierId, buildDocumentClassifierOptions.getDescription(), Transforms.toInnerDocTypes(documentTypes));
                return this.documentClassifiersImpl.buildClassifierWithResponseAsync(buildDocumentModelRequest, context).map(response -> Transforms.toDocumentOperationResult(((DocumentClassifiersBuildClassifierHeaders)response.getDeserializedHeaders()).getOperationLocation())).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<OperationResult>> processBuildingModelResponse(com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails getOperationResponse, PollResponse<OperationResult> trainingModelOperationResponse) {
        LongRunningOperationStatus status;
        switch (getOperationResponse.getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)((Object)Transforms.mapResponseErrorToHttpResponseException(getOperationResponse.getError())));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)getOperationResponse.getStatus().toString(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((OperationResult)trainingModelOperationResponse.getValue())));
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> getCopyActivationOperation(String modelId, DocumentModelCopyAuthorization target, Context context) {
        return pollingContext -> {
            try {
                if (modelId == null) {
                    return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'modelId' cannot be null."));
                }
                if (target == null) {
                    return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'target' cannot be null."));
                }
                CopyAuthorization copyRequest = Transforms.getInnerCopyAuthorization(target);
                return this.documentModelsImpl.copyModelToWithResponseAsync(modelId, copyRequest, context).map(response -> Transforms.toDocumentOperationResult(((DocumentModelsCopyModelToHeaders)response.getDeserializedHeaders()).getOperationLocation())).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PagedResponse<DocumentModelSummary>> listFirstPageModelInfo(Context context) {
        return this.documentModelsImpl.listModelsSinglePageAsync(context).doOnRequest(ignoredValue -> this.logger.info("Listing information for all models")).doOnSuccess(response -> this.logger.info("Listed all models")).doOnError(error -> this.logger.warning("Failed to list all models information", new Object[]{error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toDocumentModelInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<DocumentModelSummary>> listNextPageModelInfo(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.documentModelsImpl.listModelsNextSinglePageAsync(nextPageLink, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toDocumentModelInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<OperationSummary>> listFirstPageOperationInfo(Context context) {
        return this.miscellaneousImpl.listOperationsSinglePageAsync(context).doOnRequest(ignoredValue -> this.logger.info("Listing information for all operations")).doOnSuccess(response -> this.logger.info("Listed all operations")).doOnError(error -> this.logger.warning("Failed to list all operations information", new Object[]{error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toOperationSummary(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<OperationSummary>> listNextPageOperationInfo(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.miscellaneousImpl.listOperationsNextSinglePageAsync(nextPageLink, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).onErrorMap(Transforms::mapToHttpResponseExceptionIfExists).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), Transforms.toOperationSummary(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private static <T> BiFunction<PollingContext<T>, PollResponse<T>, Mono<T>> cancellationNotSupported() {
        return (pollingContext, pollResponse) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported"));
    }
}

