/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.Document;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentKeyValuePair;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentLanguage;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentPage;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentParagraph;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentStyle;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentTable;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class AnalyzeResult
implements JsonSerializable<AnalyzeResult> {
    private final String apiVersion;
    private final String modelId;
    private final StringIndexType stringIndexType;
    private final String content;
    private final List<DocumentPage> pages;
    private List<DocumentParagraph> paragraphs;
    private List<DocumentTable> tables;
    private List<DocumentKeyValuePair> keyValuePairs;
    private List<DocumentStyle> styles;
    private List<DocumentLanguage> languages;
    private List<Document> documents;

    public AnalyzeResult(String apiVersion, String modelId, StringIndexType stringIndexType, String content, List<DocumentPage> pages) {
        this.apiVersion = apiVersion;
        this.modelId = modelId;
        this.stringIndexType = stringIndexType;
        this.content = content;
        this.pages = pages;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getModelId() {
        return this.modelId;
    }

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public String getContent() {
        return this.content;
    }

    public List<DocumentPage> getPages() {
        return this.pages;
    }

    public List<DocumentParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public AnalyzeResult setParagraphs(List<DocumentParagraph> paragraphs) {
        this.paragraphs = paragraphs;
        return this;
    }

    public List<DocumentTable> getTables() {
        return this.tables;
    }

    public AnalyzeResult setTables(List<DocumentTable> tables) {
        this.tables = tables;
        return this;
    }

    public List<DocumentKeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public AnalyzeResult setKeyValuePairs(List<DocumentKeyValuePair> keyValuePairs) {
        this.keyValuePairs = keyValuePairs;
        return this;
    }

    public List<DocumentStyle> getStyles() {
        return this.styles;
    }

    public AnalyzeResult setStyles(List<DocumentStyle> styles) {
        this.styles = styles;
        return this;
    }

    public List<DocumentLanguage> getLanguages() {
        return this.languages;
    }

    public AnalyzeResult setLanguages(List<DocumentLanguage> languages) {
        this.languages = languages;
        return this;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public AnalyzeResult setDocuments(List<Document> documents) {
        this.documents = documents;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("stringIndexType", this.stringIndexType == null ? null : this.stringIndexType.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("pages", this.pages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("paragraphs", this.paragraphs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("keyValuePairs", this.keyValuePairs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("styles", this.styles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("languages", this.languages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeResult fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeResult)jsonReader.readObject(reader -> {
            boolean apiVersionFound = false;
            String apiVersion = null;
            boolean modelIdFound = false;
            String modelId = null;
            boolean stringIndexTypeFound = false;
            StringIndexType stringIndexType = null;
            boolean contentFound = false;
            String content = null;
            boolean pagesFound = false;
            List pages = null;
            List paragraphs = null;
            List tables = null;
            List keyValuePairs = null;
            List styles = null;
            List languages = null;
            List documents = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    apiVersionFound = true;
                    continue;
                }
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    modelIdFound = true;
                    continue;
                }
                if ("stringIndexType".equals(fieldName)) {
                    stringIndexType = StringIndexType.fromString(reader.getString());
                    stringIndexTypeFound = true;
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    contentFound = true;
                    continue;
                }
                if ("pages".equals(fieldName)) {
                    pages = reader.readArray(reader1 -> DocumentPage.fromJson(reader1));
                    pagesFound = true;
                    continue;
                }
                if ("paragraphs".equals(fieldName)) {
                    paragraphs = reader.readArray(reader1 -> DocumentParagraph.fromJson(reader1));
                    continue;
                }
                if ("tables".equals(fieldName)) {
                    tables = reader.readArray(reader1 -> DocumentTable.fromJson(reader1));
                    continue;
                }
                if ("keyValuePairs".equals(fieldName)) {
                    keyValuePairs = reader.readArray(reader1 -> DocumentKeyValuePair.fromJson(reader1));
                    continue;
                }
                if ("styles".equals(fieldName)) {
                    styles = reader.readArray(reader1 -> DocumentStyle.fromJson(reader1));
                    continue;
                }
                if ("languages".equals(fieldName)) {
                    languages = reader.readArray(reader1 -> DocumentLanguage.fromJson(reader1));
                    continue;
                }
                if ("documents".equals(fieldName)) {
                    documents = reader.readArray(reader1 -> Document.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (apiVersionFound && modelIdFound && stringIndexTypeFound && contentFound && pagesFound) {
                AnalyzeResult deserializedAnalyzeResult = new AnalyzeResult(apiVersion, modelId, stringIndexType, content, pages);
                deserializedAnalyzeResult.paragraphs = paragraphs;
                deserializedAnalyzeResult.tables = tables;
                deserializedAnalyzeResult.keyValuePairs = keyValuePairs;
                deserializedAnalyzeResult.styles = styles;
                deserializedAnalyzeResult.languages = languages;
                deserializedAnalyzeResult.documents = documents;
                return deserializedAnalyzeResult;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!apiVersionFound) {
                missingProperties.add("apiVersion");
            }
            if (!modelIdFound) {
                missingProperties.add("modelId");
            }
            if (!stringIndexTypeFound) {
                missingProperties.add("stringIndexType");
            }
            if (!contentFound) {
                missingProperties.add("content");
            }
            if (!pagesFound) {
                missingProperties.add("pages");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

