/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class AzureBlobFileListContentSource
implements JsonSerializable<AzureBlobFileListContentSource> {
    private final String containerUrl;
    private final String fileList;

    public AzureBlobFileListContentSource(String containerUrl, String fileList) {
        this.containerUrl = containerUrl;
        this.fileList = fileList;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public String getFileList() {
        return this.fileList;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerUrl", this.containerUrl);
        jsonWriter.writeStringField("fileList", this.fileList);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFileListContentSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFileListContentSource)jsonReader.readObject(reader -> {
            boolean containerUrlFound = false;
            String containerUrl = null;
            boolean fileListFound = false;
            String fileList = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerUrl".equals(fieldName)) {
                    containerUrl = reader.getString();
                    containerUrlFound = true;
                    continue;
                }
                if ("fileList".equals(fieldName)) {
                    fileList = reader.getString();
                    fileListFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (containerUrlFound && fileListFound) {
                return new AzureBlobFileListContentSource(containerUrl, fileList);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!containerUrlFound) {
                missingProperties.add("containerUrl");
            }
            if (!fileListFound) {
                missingProperties.add("fileList");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

