/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class BoundingRegion
implements JsonSerializable<BoundingRegion> {
    private final int pageNumber;
    private final List<Float> polygon;

    public BoundingRegion(int pageNumber, List<Float> polygon) {
        this.pageNumber = pageNumber;
        this.polygon = polygon;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public List<Float> getPolygon() {
        return this.polygon;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("pageNumber", this.pageNumber);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeFloat(element.floatValue()));
        return jsonWriter.writeEndObject();
    }

    public static BoundingRegion fromJson(JsonReader jsonReader) throws IOException {
        return (BoundingRegion)jsonReader.readObject(reader -> {
            boolean pageNumberFound = false;
            int pageNumber = 0;
            boolean polygonFound = false;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pageNumber".equals(fieldName)) {
                    pageNumber = reader.getInt();
                    pageNumberFound = true;
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    polygonFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (pageNumberFound && polygonFound) {
                return new BoundingRegion(pageNumber, polygon);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!pageNumberFound) {
                missingProperties.add("pageNumber");
            }
            if (!polygonFound) {
                missingProperties.add("polygon");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

