/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BoundingRegion;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentField;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class Document
implements JsonSerializable<Document> {
    private final String docType;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;
    private Map<String, DocumentField> fields;
    private final float confidence;

    public Document(String docType, List<DocumentSpan> spans, float confidence) {
        this.docType = docType;
        this.spans = spans;
        this.confidence = confidence;
    }

    public String getDocType() {
        return this.docType;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public Document setBoundingRegions(List<BoundingRegion> boundingRegions) {
        this.boundingRegions = boundingRegions;
        return this;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public Map<String, DocumentField> getFields() {
        return this.fields;
    }

    public Document setFields(Map<String, DocumentField> fields) {
        this.fields = fields;
        return this;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("docType", this.docType);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("fields", this.fields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Document fromJson(JsonReader jsonReader) throws IOException {
        return (Document)jsonReader.readObject(reader -> {
            boolean docTypeFound = false;
            String docType = null;
            boolean spansFound = false;
            List spans = null;
            boolean confidenceFound = false;
            float confidence = 0.0f;
            List boundingRegions = null;
            Map fields = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("docType".equals(fieldName)) {
                    docType = reader.getString();
                    docTypeFound = true;
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    spansFound = true;
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getFloat();
                    confidenceFound = true;
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    fields = reader.readMap(reader1 -> DocumentField.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (docTypeFound && spansFound && confidenceFound) {
                Document deserializedDocument = new Document(docType, spans, confidence);
                deserializedDocument.boundingRegions = boundingRegions;
                deserializedDocument.fields = fields;
                return deserializedDocument;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!docTypeFound) {
                missingProperties.add("docType");
            }
            if (!spansFound) {
                missingProperties.add("spans");
            }
            if (!confidenceFound) {
                missingProperties.add("confidence");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

