/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AddressValue;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BoundingRegion;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CurrencyValue;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentFieldType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSignatureType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.SelectionMarkState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class DocumentField
implements JsonSerializable<DocumentField> {
    private final DocumentFieldType type;
    private String valueString;
    private LocalDate valueDate;
    private String valueTime;
    private String valuePhoneNumber;
    private Float valueNumber;
    private Long valueInteger;
    private SelectionMarkState valueSelectionMark;
    private DocumentSignatureType valueSignature;
    private String valueCountryRegion;
    private List<DocumentField> valueArray;
    private Map<String, DocumentField> valueObject;
    private CurrencyValue valueCurrency;
    private AddressValue valueAddress;
    private Boolean valueBoolean;
    private String content;
    private List<BoundingRegion> boundingRegions;
    private List<DocumentSpan> spans;
    private Float confidence;

    public DocumentField(DocumentFieldType type) {
        this.type = type;
    }

    public DocumentFieldType getType() {
        return this.type;
    }

    public String getValueString() {
        return this.valueString;
    }

    public DocumentField setValueString(String valueString) {
        this.valueString = valueString;
        return this;
    }

    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public DocumentField setValueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    public String getValueTime() {
        return this.valueTime;
    }

    public DocumentField setValueTime(String valueTime) {
        this.valueTime = valueTime;
        return this;
    }

    public String getValuePhoneNumber() {
        return this.valuePhoneNumber;
    }

    public DocumentField setValuePhoneNumber(String valuePhoneNumber) {
        this.valuePhoneNumber = valuePhoneNumber;
        return this;
    }

    public Float getValueNumber() {
        return this.valueNumber;
    }

    public DocumentField setValueNumber(Float valueNumber) {
        this.valueNumber = valueNumber;
        return this;
    }

    public Long getValueInteger() {
        return this.valueInteger;
    }

    public DocumentField setValueInteger(Long valueInteger) {
        this.valueInteger = valueInteger;
        return this;
    }

    public SelectionMarkState getValueSelectionMark() {
        return this.valueSelectionMark;
    }

    public DocumentField setValueSelectionMark(SelectionMarkState valueSelectionMark) {
        this.valueSelectionMark = valueSelectionMark;
        return this;
    }

    public DocumentSignatureType getValueSignature() {
        return this.valueSignature;
    }

    public DocumentField setValueSignature(DocumentSignatureType valueSignature) {
        this.valueSignature = valueSignature;
        return this;
    }

    public String getValueCountryRegion() {
        return this.valueCountryRegion;
    }

    public DocumentField setValueCountryRegion(String valueCountryRegion) {
        this.valueCountryRegion = valueCountryRegion;
        return this;
    }

    public List<DocumentField> getValueArray() {
        return this.valueArray;
    }

    public DocumentField setValueArray(List<DocumentField> valueArray) {
        this.valueArray = valueArray;
        return this;
    }

    public Map<String, DocumentField> getValueObject() {
        return this.valueObject;
    }

    public DocumentField setValueObject(Map<String, DocumentField> valueObject) {
        this.valueObject = valueObject;
        return this;
    }

    public CurrencyValue getValueCurrency() {
        return this.valueCurrency;
    }

    public DocumentField setValueCurrency(CurrencyValue valueCurrency) {
        this.valueCurrency = valueCurrency;
        return this;
    }

    public AddressValue getValueAddress() {
        return this.valueAddress;
    }

    public DocumentField setValueAddress(AddressValue valueAddress) {
        this.valueAddress = valueAddress;
        return this;
    }

    public Boolean isValueBoolean() {
        return this.valueBoolean;
    }

    public DocumentField setValueBoolean(Boolean valueBoolean) {
        this.valueBoolean = valueBoolean;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public DocumentField setContent(String content) {
        this.content = content;
        return this;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public DocumentField setBoundingRegions(List<BoundingRegion> boundingRegions) {
        this.boundingRegions = boundingRegions;
        return this;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public DocumentField setSpans(List<DocumentSpan> spans) {
        this.spans = spans;
        return this;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public DocumentField setConfidence(Float confidence) {
        this.confidence = confidence;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("valueString", this.valueString);
        jsonWriter.writeStringField("valueDate", Objects.toString(this.valueDate, null));
        jsonWriter.writeStringField("valueTime", this.valueTime);
        jsonWriter.writeStringField("valuePhoneNumber", this.valuePhoneNumber);
        jsonWriter.writeNumberField("valueNumber", (Number)this.valueNumber);
        jsonWriter.writeNumberField("valueInteger", (Number)this.valueInteger);
        jsonWriter.writeStringField("valueSelectionMark", this.valueSelectionMark == null ? null : this.valueSelectionMark.toString());
        jsonWriter.writeStringField("valueSignature", this.valueSignature == null ? null : this.valueSignature.toString());
        jsonWriter.writeStringField("valueCountryRegion", this.valueCountryRegion);
        jsonWriter.writeArrayField("valueArray", this.valueArray, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("valueObject", this.valueObject, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("valueCurrency", (JsonSerializable)this.valueCurrency);
        jsonWriter.writeJsonField("valueAddress", (JsonSerializable)this.valueAddress);
        jsonWriter.writeBooleanField("valueBoolean", this.valueBoolean);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("confidence", (Number)this.confidence);
        return jsonWriter.writeEndObject();
    }

    public static DocumentField fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentField)jsonReader.readObject(reader -> {
            boolean typeFound = false;
            DocumentFieldType type = null;
            String valueString = null;
            LocalDate valueDate = null;
            String valueTime = null;
            String valuePhoneNumber = null;
            Float valueNumber = null;
            Long valueInteger = null;
            SelectionMarkState valueSelectionMark = null;
            DocumentSignatureType valueSignature = null;
            String valueCountryRegion = null;
            List valueArray = null;
            Map valueObject = null;
            CurrencyValue valueCurrency = null;
            AddressValue valueAddress = null;
            Boolean valueBoolean = null;
            String content = null;
            List boundingRegions = null;
            List spans = null;
            Float confidence = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    type = DocumentFieldType.fromString(reader.getString());
                    typeFound = true;
                    continue;
                }
                if ("valueString".equals(fieldName)) {
                    valueString = reader.getString();
                    continue;
                }
                if ("valueDate".equals(fieldName)) {
                    valueDate = (LocalDate)reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                    continue;
                }
                if ("valueTime".equals(fieldName)) {
                    valueTime = reader.getString();
                    continue;
                }
                if ("valuePhoneNumber".equals(fieldName)) {
                    valuePhoneNumber = reader.getString();
                    continue;
                }
                if ("valueNumber".equals(fieldName)) {
                    valueNumber = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("valueInteger".equals(fieldName)) {
                    valueInteger = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("valueSelectionMark".equals(fieldName)) {
                    valueSelectionMark = SelectionMarkState.fromString(reader.getString());
                    continue;
                }
                if ("valueSignature".equals(fieldName)) {
                    valueSignature = DocumentSignatureType.fromString(reader.getString());
                    continue;
                }
                if ("valueCountryRegion".equals(fieldName)) {
                    valueCountryRegion = reader.getString();
                    continue;
                }
                if ("valueArray".equals(fieldName)) {
                    valueArray = reader.readArray(reader1 -> DocumentField.fromJson(reader1));
                    continue;
                }
                if ("valueObject".equals(fieldName)) {
                    valueObject = reader.readMap(reader1 -> DocumentField.fromJson(reader1));
                    continue;
                }
                if ("valueCurrency".equals(fieldName)) {
                    valueCurrency = CurrencyValue.fromJson(reader);
                    continue;
                }
                if ("valueAddress".equals(fieldName)) {
                    valueAddress = AddressValue.fromJson(reader);
                    continue;
                }
                if ("valueBoolean".equals(fieldName)) {
                    valueBoolean = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            if (typeFound) {
                DocumentField deserializedDocumentField = new DocumentField(type);
                deserializedDocumentField.valueString = valueString;
                deserializedDocumentField.valueDate = valueDate;
                deserializedDocumentField.valueTime = valueTime;
                deserializedDocumentField.valuePhoneNumber = valuePhoneNumber;
                deserializedDocumentField.valueNumber = valueNumber;
                deserializedDocumentField.valueInteger = valueInteger;
                deserializedDocumentField.valueSelectionMark = valueSelectionMark;
                deserializedDocumentField.valueSignature = valueSignature;
                deserializedDocumentField.valueCountryRegion = valueCountryRegion;
                deserializedDocumentField.valueArray = valueArray;
                deserializedDocumentField.valueObject = valueObject;
                deserializedDocumentField.valueCurrency = valueCurrency;
                deserializedDocumentField.valueAddress = valueAddress;
                deserializedDocumentField.valueBoolean = valueBoolean;
                deserializedDocumentField.content = content;
                deserializedDocumentField.boundingRegions = boundingRegions;
                deserializedDocumentField.spans = spans;
                deserializedDocumentField.confidence = confidence;
                return deserializedDocumentField;
            }
            throw new IllegalStateException("Missing required property: type");
        });
    }
}

