/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentKeyValueElement;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class DocumentKeyValuePair
implements JsonSerializable<DocumentKeyValuePair> {
    private final DocumentKeyValueElement key;
    private DocumentKeyValueElement value;
    private final float confidence;

    public DocumentKeyValuePair(DocumentKeyValueElement key, float confidence) {
        this.key = key;
        this.confidence = confidence;
    }

    public DocumentKeyValueElement getKey() {
        return this.key;
    }

    public DocumentKeyValueElement getValue() {
        return this.value;
    }

    public DocumentKeyValuePair setValue(DocumentKeyValueElement value) {
        this.value = value;
        return this;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", (JsonSerializable)this.key);
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeJsonField("value", (JsonSerializable)this.value);
        return jsonWriter.writeEndObject();
    }

    public static DocumentKeyValuePair fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentKeyValuePair)jsonReader.readObject(reader -> {
            boolean keyFound = false;
            DocumentKeyValueElement key = null;
            boolean confidenceFound = false;
            float confidence = 0.0f;
            DocumentKeyValueElement value = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = DocumentKeyValueElement.fromJson(reader);
                    keyFound = true;
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getFloat();
                    confidenceFound = true;
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = DocumentKeyValueElement.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (keyFound && confidenceFound) {
                DocumentKeyValuePair deserializedDocumentKeyValuePair = new DocumentKeyValuePair(key, confidence);
                deserializedDocumentKeyValuePair.value = value;
                return deserializedDocumentKeyValuePair;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!keyFound) {
                missingProperties.add("key");
            }
            if (!confidenceFound) {
                missingProperties.add("confidence");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

