/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentSpan;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.SelectionMarkState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DocumentSelectionMark
implements JsonSerializable<DocumentSelectionMark> {
    private final SelectionMarkState state;
    private List<Float> polygon;
    private final DocumentSpan span;
    private final float confidence;

    public DocumentSelectionMark(SelectionMarkState state, DocumentSpan span, float confidence) {
        this.state = state;
        this.span = span;
        this.confidence = confidence;
    }

    public SelectionMarkState getState() {
        return this.state;
    }

    public List<Float> getPolygon() {
        return this.polygon;
    }

    public DocumentSelectionMark setPolygon(List<Float> polygon) {
        this.polygon = polygon;
        return this;
    }

    public DocumentSpan getSpan() {
        return this.span;
    }

    public float getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("span", (JsonSerializable)this.span);
        jsonWriter.writeFloatField("confidence", this.confidence);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeFloat(element.floatValue()));
        return jsonWriter.writeEndObject();
    }

    public static DocumentSelectionMark fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentSelectionMark)jsonReader.readObject(reader -> {
            boolean stateFound = false;
            SelectionMarkState state = null;
            boolean spanFound = false;
            DocumentSpan span = null;
            boolean confidenceFound = false;
            float confidence = 0.0f;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    state = SelectionMarkState.fromString(reader.getString());
                    stateFound = true;
                    continue;
                }
                if ("span".equals(fieldName)) {
                    span = DocumentSpan.fromJson(reader);
                    spanFound = true;
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getFloat();
                    confidenceFound = true;
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> Float.valueOf(reader1.getFloat()));
                    continue;
                }
                reader.skipChildren();
            }
            if (stateFound && spanFound && confidenceFound) {
                DocumentSelectionMark deserializedDocumentSelectionMark = new DocumentSelectionMark(state, span, confidence);
                deserializedDocumentSelectionMark.polygon = polygon;
                return deserializedDocumentSelectionMark;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!stateFound) {
                missingProperties.add("state");
            }
            if (!spanFound) {
                missingProperties.add("span");
            }
            if (!confidenceFound) {
                missingProperties.add("confidence");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

